/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jeeweb.common.util.http;

import cn.com.jeeweb.common.util.CharsetUtil;
import cn.com.jeeweb.common.util.Exceptions;
import cn.com.jeeweb.common.util.MapUtil;
import cn.com.jeeweb.common.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpURLConnectionUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpURLConnectionUtil.class);
    public static String METHOD_GET = "GET";
    public static String METHOD_POST = "POST";

    public static String sendGet(String url) {
        return HttpURLConnectionUtil.sendGet(url, null, null);
    }

    public static String sendGet(String url, String param) {
        return HttpURLConnectionUtil.sendGet(url, param, null);
    }

    public static String sendGet(String url, Map<String, String> header) {
        return HttpURLConnectionUtil.sendGet(url, null, header);
    }

    public static String sendGet(String url, String param, Map<String, String> header) {
        return HttpURLConnectionUtil.requestAsString(url, METHOD_GET, param, header);
    }

    public static String sendPost(String url) {
        return HttpURLConnectionUtil.sendPost(url, null, null);
    }

    public static String sendPost(String url, String param) {
        return HttpURLConnectionUtil.sendPost(url, param, null);
    }

    public static String sendPost(String url, Map<String, String> header) {
        return HttpURLConnectionUtil.sendPost(url, null, header);
    }

    public static String sendPostForJson(String url, String param) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json; charset=UTF-8");
        header.put("accept", "application/json");
        return HttpURLConnectionUtil.sendPost(url, param, header);
    }

    public static String sendPost(String url, String param, Map<String, String> header) {
        return HttpURLConnectionUtil.requestAsString(url, METHOD_POST, param, header);
    }

    public static File sendPostAsFile(String url, String params, File file) {
        return HttpURLConnectionUtil.requestAsFile(url, METHOD_POST, params, null, file);
    }

    public static File sendPostAsFile(String url, String params, Map<String, String> header, File file) {
        return HttpURLConnectionUtil.requestAsFile(url, METHOD_POST, params, header, file);
    }

    public static File sendPostAsFileForJson(String url, String params, File file) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json; charset=UTF-8");
        return HttpURLConnectionUtil.requestAsFile(url, METHOD_POST, params, null, file);
    }

    public static File requestAsFile(String url, String method, String params, Map<String, String> requestHeader, File file) {
        try {
            int len;
            HttpURLConnection conn = HttpURLConnectionUtil.getURLConnection(url, method, params, requestHeader);
            logger.debug("\u54cd\u5e94\u72b6\u6001\u7801\u662f\uff1a{}", (Object)conn.getResponseCode());
            InputStream inputStream = conn.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            FileOutputStream os = new FileOutputStream(file);
            byte[] arr = new byte[1024];
            while ((len = bis.read(arr)) != -1) {
                ((OutputStream)os).write(arr, 0, len);
                os.flush();
            }
            ((OutputStream)os).close();
            bis.close();
            inputStream.close();
            conn.disconnect();
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
        logger.debug("\u54cd\u5e94\u7684\u6587\u4ef6\u5927\u5c0f\u662f\uff1a{}", (Object)file.length());
        return file;
    }

    public static String requestAsString(String url, String method, String params, Map<String, String> requestHeader) {
        return HttpURLConnectionUtil.requestAsString_1(url, method, params, requestHeader);
    }

    public static String requestAsString_1(String url, String method, String params, Map<String, String> requestHeader) {
        String responseStr = "";
        try {
            HttpURLConnection conn = HttpURLConnectionUtil.getURLConnection(url, method, params, requestHeader);
            logger.debug("\u54cd\u5e94\u72b6\u6001\u7801\u662f\uff1a{}", (Object)conn.getResponseCode());
            InputStream inputStream = conn.getInputStream();
            Scanner scanner = new Scanner(inputStream, CharsetUtil.DEFAULT_CHARSET_NAME);
            StringBuffer buffer = new StringBuffer();
            while (scanner.hasNextLine()) {
                buffer.append(scanner.nextLine());
            }
            responseStr = buffer.toString();
            scanner.close();
            inputStream.close();
            conn.disconnect();
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
        logger.debug("response_str: {}", (Object)responseStr);
        return responseStr;
    }

    public static String requestAsString_2(String url, String method, String params, Map<String, String> requestHeader) {
        StringBuffer buffer = new StringBuffer();
        try {
            HttpURLConnection conn = HttpURLConnectionUtil.getURLConnection(url, method, params, requestHeader);
            InputStream inputStream = conn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, CharsetUtil.DEFAULT_CHARSET_NAME);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            conn.disconnect();
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
        return buffer.toString();
    }

    public static HttpURLConnection getURLConnection(String httpUrl) throws Exception {
        return HttpURLConnectionUtil.getURLConnection(httpUrl, METHOD_GET, null, null);
    }

    public static HttpURLConnection getURLConnection(String httpUrl, String method) throws Exception {
        return HttpURLConnectionUtil.getURLConnection(httpUrl, method, null, null);
    }

    public static HttpURLConnection getURLConnection(String httpUrl, String method, Map<String, String> requestHeader) throws Exception {
        return HttpURLConnectionUtil.getURLConnection(httpUrl, method, null, requestHeader);
    }

    public static HttpURLConnection getURLConnection(String httpUrl, String method, String params) throws Exception {
        return HttpURLConnectionUtil.getURLConnection(httpUrl, method, params, null);
    }

    public static HttpURLConnection getURLConnection(String httpUrl, String method, String params, Map<String, String> requestHeader) throws Exception {
        if (StringUtil.equalsIgnoreCase((CharSequence)METHOD_GET, (CharSequence)method) && StringUtil.isNotBlank((CharSequence)params)) {
            httpUrl = httpUrl + "?" + params;
        }
        URL url = new URL(httpUrl);
        HttpURLConnection conn = null;
        if ("HTTPS".equals(url.getProtocol().toUpperCase())) {
            HttpsURLConnection connectionHttps = (HttpsURLConnection)url.openConnection();
            connectionHttps.setSSLSocketFactory(HttpURLConnectionUtil.getSSLSocket());
            conn = connectionHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("accept", "*/*");
        conn.setRequestProperty("Accept-Charset", "UTF-8");
        conn.setRequestProperty("connection", "Keep-Alive");
        conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
        if (MapUtil.isNotEmpty(requestHeader)) {
            for (Map.Entry entry : requestHeader.entrySet()) {
                conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        conn.setRequestMethod(method);
        if (StringUtil.equalsIgnoreCase((CharSequence)METHOD_GET, (CharSequence)method)) {
            conn.setUseCaches(true);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)METHOD_POST, (CharSequence)method)) {
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            if (StringUtil.isNotBlank((CharSequence)params)) {
                PrintWriter out = new PrintWriter(conn.getOutputStream());
                out.print(params);
                out.flush();
                out.close();
            }
        }
        conn.connect();
        return conn;
    }

    private static SSLSocketFactory getSSLSocket() throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
        sslContext.init(null, tm, new SecureRandom());
        SSLSocketFactory ssf = sslContext.getSocketFactory();
        return ssf;
    }

    public static String toParamStr(Map<String, String> param) throws UnsupportedEncodingException {
        String reStr = "";
        if (MapUtil.isEmpty(param)) {
            return reStr;
        }
        Set<Map.Entry<String, String>> entrySet = param.entrySet();
        for (Map.Entry<String, String> o : entrySet) {
            if (o.getValue() == null || "null".equals(o.getValue()) || "class".equals(o.getKey())) continue;
            String s = o.getKey() + "=" + o.getValue();
            reStr = reStr + s + "&";
        }
        return StringUtil.isBlank((CharSequence)reStr) ? "" : reStr.substring(0, reStr.length() - 1);
    }

    public static Map<String, String> toParamMap(String param) throws UnsupportedEncodingException {
        String[] paramPairsArr;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (StringUtil.isBlank((CharSequence)param)) {
            return paramMap;
        }
        for (String paramPair : paramPairsArr = param.split("&")) {
            String[] paramPairArr = paramPair.split("=");
            if (paramPairArr.length == 2) {
                paramMap.put(paramPairArr[0].trim(), paramPairArr[1].trim());
                continue;
            }
            paramMap.put(paramPairArr[0].trim(), "");
        }
        return paramMap;
    }

    public static Boolean isHttpUrl(String url) {
        boolean flag = false;
        try {
            flag = url.indexOf("://") != -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }
}

