/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jeeweb.common.util.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

public class JacksonUtil {
    private static ObjectMapper mapper = null;

    public static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, true);
        }
        return mapper;
    }

    public static String toJsonString(Object obj) {
        String json = "";
        try {
            json = JacksonUtil.getMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            json = "";
            e.printStackTrace();
        }
        return json;
    }

    public static Object readJson(byte[] json, Class clazz) {
        try {
            return JacksonUtil.getMapper().readValue(json, clazz);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T readJson(InputStream json, Class<T> valueType) {
        try {
            return (T)JacksonUtil.getMapper().readValue(json, valueType);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T readJson(String json, Class<T> valueType) {
        try {
            return (T)JacksonUtil.getMapper().readValue(json, valueType);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T readJson(File json, Class<T> valueType) {
        try {
            return (T)JacksonUtil.getMapper().readValue(json, valueType);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> void writeJson(File resultFile, T value) {
        try {
            JacksonUtil.getMapper().writeValue(resultFile, value);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> T jsonToList(String json, Class<T> valueType) throws Exception {
        JavaType javaType = JacksonUtil.getCollectionType(ArrayList.class, valueType);
        return (T)mapper.readValue(json, javaType);
    }

    public static <T> T jsonCollectionType(String json, JavaType javaType) throws Exception {
        return (T)mapper.readValue(json, javaType);
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static JsonNode readTree(String content) throws IOException {
        return JacksonUtil.getMapper().readTree(content);
    }

    public static ObjectNode createObjectNode(Map<String, String> map) {
        ObjectNode jsonObject = JacksonUtil.getMapper().createObjectNode();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            jsonObject.put(key, value);
        }
        return jsonObject;
    }

    public static void main(String[] args) {
        String json = "{\"access_token\":\"8x_u-fYL2ZrmiitGIQTRxb6UpZr8uAWQHEd-Cp4NQB1_P_nrw3kLyDAklwbWK3W7SIgHcc1_DZ2paxz8DR34I3UYy66IcPDlqOSpNOpjN1gzvy4nIeDxF3_W8Zq6DTZ_IBOaAIAEXK\",\"expires_in\":7200}";
        Map parseJson = JacksonUtil.readJson(json, Map.class);
        System.out.println(parseJson);
    }
}

