package cn.net.wanmo.plugin.wechat.officialaccount.pojo;

import cn.net.wanmo.common.restful.body.BodyType;
import cn.net.wanmo.common.restful.body.Res;
import com.alibaba.fastjson.JSONObject;

public class WechatRes extends Res<Integer> {

    public WechatRes() {
        super();
        this.bodyType = BodyType.obj;
    }

    public WechatRes(Integer errCode, String errMsg) {
        super(errCode, errMsg);
    }

    @Override
    public Res parseCodeMsg(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);
        this.errCode = object.getIntValue("errcode");
        this.errMsg = object.getString("errmsg");

        return super.parseCodeMsg(resBody);
    }

    @Override
    public Integer defaultErrCode() {
        return 0;
    }

    @Override
    public boolean isSuccess() {
        return defaultErrCode().intValue() == getErrCode().intValue();
    }

    /**
     * 是否成功响应
     *
     * @return 是否
     */
    public boolean isOk() {
        return isSuccess();
    }
}
