package cn.net.wanmo.plugin.wechat.officialaccount.storage;

import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.AccessToken;
import com.google.common.collect.Lists;

import java.util.*;

public class AccessTokenLog {
    /**
     * 令牌的记录 <br/>
     */
    public static Map<String, List<AccessToken>> map = new HashMap<>();

    /**
     * 每个令牌类型保存日志的最多个数
     */
    private static int maxSize = 30;


    /**
     * 获取令牌日志
     *
     * @param appId    企业ID
     * @return 日志集合
     */
    public static List<AccessToken> get(String appId) {
        List<AccessToken> list = map.getOrDefault(appId, Lists.newArrayList());
        Collections.reverse(list);
        return list;
    }


    /**
     * 添加 token 日志;
     *
     * @param appId    企业ID
     * @param accessToken       待保存的令牌
     */
    public static void put(String appId, AccessToken accessToken) {
        List<AccessToken> list = map.getOrDefault(appId, Lists.newArrayList());

        { // 添加日志
            list.add(accessToken);
        }

        { // 日志数量控制
            int size = list.size();
            for (int i = 0; i < size - maxSize; i++) {
                list.remove(0);
            }
        }

        map.put(appId, list);
    }

}
