package cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken;

/**
 * 微信通用接口凭证<br/><br/>
 * access_token的存储至少要保留512个字符空间<br/><br/>
 * access_token的有效期目前为2个小时，需定时刷新，重复获取将导致上次获取的access_token失效。<br/><br/>
 * 在刷新过程中，中控服务器可对外继续输出的老access_token，此时公众平台后台会保证在5分钟内，新老access_token都可用，这保证了第三方业务的平滑过渡；<br/><br/>
 *
 */
public class AccessToken {
    /**
     * 获取到的凭证
     */
    private String token;
    /**
     * 凭证有效时间，单位：秒
     */
    private int expiresIn;

    public AccessToken() {
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    /**
     * 子类实现,自定义存储令牌
     */
    public void storeToken() {
    }
}
