package cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken;

import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.pojo.WechatRes;
import com.alibaba.fastjson.JSONObject;

public class StableAccessTokenRes extends WechatRes {
    @Override
    public Res parse(JSONObject object) {
        if (BooleanUtil.isFalse(isOk())) {
            return this;
        }

        this.accessToken.setToken(object.getString("access_token"));
        this.accessToken.setExpiresIn(object.getIntValue("expires_in"));

        return super.parse(object);
    }

    // =========================================================

    private AccessToken accessToken = new AccessToken();

    public StableAccessTokenRes() {
    }

    public AccessToken getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }
}
