package cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.plugin.wechat.officialaccount.pojo.WechatRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtil extends WechatRes {
    private static Logger logger = LoggerFactory.getLogger(TokenUtil.class);

    /**
     * 获取访问令牌<br/>
     *
     * @param appId     公众号ID
     * @param appSecret 公众号密钥
     * @return 响应结果
     */
    public static InterfaceResult<AccessTokenRes> getAccessToken(String appId, String appSecret) {
        AccessTokenReq req = AccessTokenReq.build(appId, appSecret);
        return getAccessToken(null, req);
    }

    /**
     * 获取访问令牌<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<AccessTokenRes> getAccessToken(String logPrevDesc, AccessTokenReq req) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 获取访问令牌: ");

        // 获取access_token的接口地址（GET） 限200（次/天）
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";

        url = url.replace("APPID", req.getAppId()).replace("APPSECRET", req.getAppSecret());

        AccessTokenRes res = new AccessTokenRes();
        return SendUtil.sendGet(msgPre, url, req, res, logger, Integer.class);
    }

    /**
     * 获取稳定版接口调用凭据<br/>
     *
     * @param appId     公众号ID
     * @param appSecret 公众号密钥
     * @return 响应结果
     */
    public static InterfaceResult<StableAccessTokenRes> getStableAccessToken(String appId, String appSecret) {
        StableAccessTokenReq req = StableAccessTokenReq.build(appId, appSecret);
        return getStableAccessToken(null, req);
    }

    /**
     * 获取稳定版接口调用凭据<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<StableAccessTokenRes> getStableAccessToken(String logPrevDesc, StableAccessTokenReq req) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 获取稳定版接口调用凭据: ");

        String url = "https://api.weixin.qq.com/cgi-bin/stable_token";

        req.setBody(req.toJSONString());
        StableAccessTokenRes res = new StableAccessTokenRes();
        return SendUtil.sendPostForJson(msgPre, url, req, res, logger, Integer.class);
    }


}
