package cn.net.wanmo.plugin.wechat.officialaccount.util.jsapiticket;

import com.alibaba.fastjson2.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.security.MessageDigest;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class JsSignUtil {
    private static Logger logger = LoggerFactory.getLogger(JsSignUtil.class);

    /**
     * 生成 wx.config 需要的数据
     *
     * @param jsapi_ticket 票据
     * @param request      请求地址
     * @return wx.config 需要的数据
     */
    public static Map<String, String> sign(String jsapi_ticket, HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        return sign(jsapi_ticket, url, false);
    }


    /**
     * 生成 wx.config 需要的数据
     *
     * @param jsapi_ticket 票据
     * @param request      请求地址
     * @param toHttps          是否强转为 https 协议
     * @return wx.config 需要的数据
     */
    public static Map<String, String> sign(String jsapi_ticket, HttpServletRequest request, boolean toHttps) {
        String url = request.getRequestURL().toString();
        return sign(jsapi_ticket, url, toHttps);
    }

    /**
     * 生成 wx.config 需要的数据
     *
     * @param jsapi_ticket 票据
     * @param url          请求地址
     * @param toHttps          是否强转为 https 协议
     * @return wx.config 需要的数据
     */
    public static Map<String, String> sign(String jsapi_ticket, String url, boolean toHttps) {
        Map<String, String> ret = new HashMap<>();
        logger.debug("生成 wx.config 需要的数据 jsapi_ticket : {}", jsapi_ticket);
        logger.debug("生成 wx.config 需要的数据 url : {}", url);

        if (toHttps && url.startsWith("http://")) {
            url = url.replace("http://", "https://");
            logger.debug("生成 wx.config 需要的数据 url 强转为 https协议 : {}", url);
        }

        try {
            String nonce_str = create_nonce_str();
            String timestamp = create_timestamp();
            // 注意这里参数名必须全部小写，且必须有序
            String string1 = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonce_str + "&timestamp=" + timestamp + "&url=" + url;

            String signature = "";
            { // 计算签名
                MessageDigest crypt = MessageDigest.getInstance("SHA-1");
                crypt.reset();
                crypt.update(string1.getBytes("UTF-8"));
                signature = byteToHex(crypt.digest());
            }
            logger.debug("生成 wx.config 需要的数据 signature : {}", signature);

            ret.put("url", url);
            ret.put("jsapi_ticket", jsapi_ticket);
            ret.put("nonceStr", nonce_str);
            ret.put("timestamp", timestamp);
            ret.put("signature", signature);
        } catch (Exception e) {
            ret.put("exception", e.getMessage());
            logger.error("生成 wx.config 需要的数据异常", e);
        }

        logger.debug("生成 wx.config 需要的数据：{}", JSON.toJSONString(ret));
        return ret;
    }

    private static String byteToHex(final byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    /**
     * 生成签名的随机串
     */
    private static String create_nonce_str() {
        return UUID.randomUUID().toString();
    }

    /**
     * 生成签名的时间戳
     */
    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000);
    }
}
