package cn.net.wanmo.plugin.wechat.officialaccount.util.jsapiticket;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketUtil {
    private static Logger logger = LoggerFactory.getLogger(TicketUtil.class);


    /**
     * 获取访问令牌<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static InterfaceResult<JsapiTicketRes> getJsapiTicket(String logPrevDesc, String accessToken) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 获取jsapi_ticket: ");

        String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi";
        url = url.replace("ACCESS_TOKEN", accessToken);

        JsapiTicketReq req = JsapiTicketReq.build();
        JsapiTicketRes res = new JsapiTicketRes();
        return SendUtil.sendGet(msgPre, url, req, res, logger, Integer.class);
    }
}
