package cn.net.wanmo.plugin.wechat.officialaccount.util.menu;

import cn.net.wanmo.common.util.StringUtil;

/**
 * 菜单 按钮 类型
 */
public enum MenuButtonType {
    unknown("unknown", "未知类型"),
    click("click", "点击推事件用户点击click类型按钮后"),
    view("view", "跳转URL用户点击view类型按钮后"),
    miniprogram("miniprogram", "miniprogram"),
    scancode_push("scancode_push", "扫码推事件用户点击按钮后"),
    scancode_waitmsg("scancode_waitmsg", "扫码推事件且弹出“消息接收中”提示框用户点击按钮后"),
    pic_sysphoto("pic_sysphoto", "弹出系统拍照发图用户点击按钮后"),
    pic_photo_or_album("pic_photo_or_album", "弹出拍照或者相册发图用户点击按钮后"),
    pic_weixin("pic_weixin", "弹出微信相册发图器用户点击按钮后"),
    location_select("location_select", "弹出地理位置选择器用户点击按钮后"),
    media_id("media_id", "下发消息（除文本消息）用户点击media_id类型按钮后"),
    view_limited("view_limited", "跳转图文消息URL用户点击view_limited类型按钮后"),
    article_id("article_id", "用户点击 article_id 类型按钮后"),
    article_view_limited("article_view_limited", "类似 view_limited，但不使用 media_id 而使用 article_id"),
    ;

    private final String value;
    private final String desc;

    MenuButtonType(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }

    public static MenuButtonType convertOf(String value) {
        MenuButtonType r = MenuButtonType.unknown;

        for (MenuButtonType type : values()) {
            if (StringUtil.equals(value, type.getValue())) {
                r = type;
                break;
            }
        }

        return r;
    }
}
