package cn.net.wanmo.plugin.wechat.officialaccount.util.menu;

import cn.net.wanmo.common.util.StringUtil;

/**
 * 自定义菜单 /事件推送 类型
 */
public enum MenuEventType {
    unknown("unknown", "未知类型"),
    CLICK("CLICK", "点击菜单拉取消息时的事件推送"),
    VIEW("VIEW", "点击菜单跳转链接时的事件推送"),
    scancode_push("scancode_push", "扫码推事件的事件推送"),
    scancode_waitmsg("scancode_waitmsg", "扫码推事件且弹出“消息接收中”提示框的事件推送"),
    pic_sysphoto("pic_sysphoto", "弹出系统拍照发图的事件推送"),
    pic_photo_or_album("pic_photo_or_album", "弹出拍照或者相册发图的事件推送"),
    pic_weixin("pic_weixin", "弹出微信相册发图器的事件推送"),
    location_select("location_select", "弹出地理位置选择器的事件推送"),
    view_miniprogram("view_miniprogram", "点击菜单跳转小程序的事件推送"),
    ;

    private final String value;
    private final String desc;

    MenuEventType(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }

    public static MenuEventType convertOf(String value) {
        MenuEventType r = MenuEventType.unknown;

        for (MenuEventType type : values()) {
            if (StringUtil.equals(value, type.getValue())) {
                r = type;
                break;
            }
        }

        return r;
    }
}
