package cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button;

import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.MenuButtonType;

import java.util.List;

/**
 * 按钮
 * 一级菜单数组，个数应为1~3个
 */
public class Button {
	/**
	 * 是	菜单的响应动作类型，view表示网页类型，click表示点击类型，miniprogram表示小程序类型
	 */
	protected MenuButtonType type;
	/**
	 * 是	菜单标题，不超过16个字节，子菜单不超过60个字节
	 */
	protected String name;
	/**
	 * 二级菜单数组，个数应为1~5个
	 */
	protected List<Button> subButton;


	public Button() {
		this.type = MenuButtonType.unknown;
	}

	public MenuButtonType getType() {
		return type;
	}

	public void setType(MenuButtonType type) {
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public List<Button> getSubButton() {
		return subButton;
	}

	public void setSubButton(List<Button> subButton) {
		this.subButton = subButton;
	}
}
