package cn.net.wanmo.plugin.wechat.officialaccount.util.menu.pojo;

import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.ObjectUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.MenuButtonType;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.Menu;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.*;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

public class MenuCreateReq extends Req {

    /**
     * 创建请求对象
     *
     * @return 请求对象
     */
    public static MenuCreateReq build(Menu menu) {
        MenuCreateReq req = new MenuCreateReq();
        req.setMenu(menu);
        return req;
    }


    @Override
    public String toJSONString() {
        JSONArray buttonArray = new JSONArray();
        for (Button button : this.menu.getButtons()) {
            JSONObject buttonJson = byType(button.getType(), button);

            if (CollectionUtil.isNotEmpty(button.getSubButton())) { // 有子节点
                JSONArray arraySub = new JSONArray();
                for (Button buttonSub : button.getSubButton()) {
                    arraySub.add(byType(buttonSub.getType(), buttonSub));
                }
                buttonJson.put("sub_button", arraySub);
            }

            buttonArray.add(buttonJson);
        }

        return JSONObject.of("button", buttonArray).toJSONString();
    }

    /**
     * 根据按钮类型 组织 JSON 对象
     *
     * @param type   按钮类型
     * @param button 按钮
     * @return JSON对象
     */
    private JSONObject byType(MenuButtonType type, Button button) {
        JSONObject object = new JSONObject();
        object.put("type", button.getType().getValue());
        object.put("name", button.getName());

        switch (type) {
            case click: {
                ClickButton b = ObjectUtil.cast(button);
                object.put("key", b.getKey());
                break;
            }
            case view: {
                ViewButton b = ObjectUtil.cast(button);
                object.put("url", b.getUrl());
                break;
            }
            case miniprogram: {
                MiniprogramButton b = ObjectUtil.cast(button);
                object.put("url", b.getUrl());
                object.put("appid", b.getAppid());
                object.put("pagepath", b.getPagePath());
                break;
            }
            case scancode_push: {
                ScancodePushButton b = ObjectUtil.cast(button);
                object.put("key", b.getKey());
                break;
            }
            case scancode_waitmsg: {
                ScancodeWaitmsgButton b = ObjectUtil.cast(button);
                object.put("key", b.getKey());
                break;
            }
            case pic_sysphoto: {
                PicSysphotoButton b = ObjectUtil.cast(button);
                object.put("key", b.getKey());
                break;
            }
            case pic_photo_or_album: {
                PicPhotoOrAlbumButton b = ObjectUtil.cast(button);
                object.put("key", b.getKey());
                break;
            }
            case pic_weixin: {
                PicWeixinButton b = ObjectUtil.cast(button);
                object.put("key", b.getKey());
                break;
            }
            case location_select: {
                LocationSelectButton b = ObjectUtil.cast(button);
                object.put("key", b.getKey());
                break;
            }
            case media_id: {
                MediaIdButton b = ObjectUtil.cast(button);
                object.put("media_id", b.getMediaId());
                break;
            }
            case view_limited: {
                ViewLimitedButton b = ObjectUtil.cast(button);
                object.put("media_id", b.getMediaId());
                break;
            }
            case article_id: {
                ArticleIdButton b = ObjectUtil.cast(button);
                object.put("article_id", b.getArticleId());
                break;
            }
            case article_view_limited: {
                ArticleViewLimitedButton b = ObjectUtil.cast(button);
                object.put("article_id", b.getArticleId());
                break;
            }
            default: {
                object.remove("type");
            }
        }

        return object;
    }

    // ===============================================
    private Menu menu = new Menu();

    public MenuCreateReq() {
    }

    public Menu getMenu() {
        return menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }
}
