package cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.base;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.ReqEventType;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.ReqMessageType;
import com.alibaba.fastjson2.JSON;

import java.util.Map;

public abstract class EventReqMessage {
    /**
     * 消息类型，event
     */
    protected ReqMessageType messageType;
    /**
     * 事件类型，subscribe(订阅)、unsubscribe(取消订阅)
     */
    protected ReqEventType eventType;
    /**
     * 开发者微信号
     */
    protected String toUserName;
    /**
     * 发送方账号（一个OpenID）
     */
    protected String fromUserName;
    /**
     * 消息创建时间 （整型）
     */
    protected Long createTime;

    /**
     * 响应的消息<br/>
     * 如果没有响应的 xml，则默认响应 "success"
     */
    protected String plainResXml = "success";

    public EventReqMessage() {
    }

    public EventReqMessage(Map<String, String> requestMap) {
        this();

        this.messageType = ReqMessageType.convertOf(requestMap.get("MsgType"));
        this.eventType = ReqEventType.convertOf(requestMap.get("Event"));
        this.toUserName = requestMap.get("ToUserName");
        this.fromUserName = requestMap.get("FromUserName");
        this.createTime = Long.valueOf(requestMap.get("CreateTime"));
    }

    public ReqMessageType getMessageType() {
        return messageType;
    }

    public void setMessageType(ReqMessageType messageType) {
        this.messageType = messageType;
    }

    public ReqEventType getEventType() {
        return eventType;
    }

    public void setEventType(ReqEventType eventType) {
        this.eventType = eventType;
    }

    public String getToUserName() {
        return toUserName;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public String getFromUserName() {
        return fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public String toJSONString() {
        return JSON.toJSONString(this);
    }

    public String getPlainResXml() {
        return plainResXml;
    }

    public void setPlainResXml(String plainResXml) {
        this.plainResXml = plainResXml;
    }
}
