package cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.base.EventReqMessage;

import java.util.Map;

/**
 * 点击菜单拉取消息时的事件推送<br/>
 * 点击菜单跳转小程序的事件推送<br/>
 * 事件类型，view_miniprogram
 */
public class MenuViewMiniprogramMessage extends EventReqMessage {

    /**
     * 事件KEY值，跳转的小程序路径 <br/>
     */
    private String eventKey;
    /**
     * 菜单ID，如果是个性化菜单，则可以通过这个字段，知道是哪个规则的菜单被点击了
     */
    private String menuId;

    public MenuViewMiniprogramMessage() {
    }

    public MenuViewMiniprogramMessage(Map<String, String> requestMap) {
        super(requestMap);
        this.eventKey = requestMap.get("EventKey");
        this.menuId = requestMap.get("MenuId");
    }

    public String getEventKey() {
        return eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public String getMenuId() {
        return menuId;
    }

    public void setMenuId(String menuId) {
        this.menuId = menuId;
    }
}
