package cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.scan;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.base.EventReqMessage;

import java.util.Map;

/**
 * 扫描带参数二维码事件<br/>
 * 用户未关注时，进行关注后的事件推送<br/>
 * 如果用户还未关注公众号，则用户可以关注公众号，关注后微信会将带场景值关注事件推送给开发者。<br/>
 * 事件类型，subscribe
 */
public class ScanSubscribeNoMessage extends EventReqMessage {
    /**
     * 事件KEY值，qrscene_为前缀，后面为二维码的参数值
     */
    private String eventKey;
    /**
     * 二维码的ticket，可用来换取二维码图片
     */
    private String ticket;

    public ScanSubscribeNoMessage() {
    }

    public ScanSubscribeNoMessage(Map<String, String> requestMap) {
        super(requestMap);
        this.eventKey = requestMap.get("EventKey");
        {
            String prevStr = "qrscene_";
            if (StringUtil.isNotBlank(this.eventKey) && this.eventKey.startsWith(prevStr)) {
                this.eventKey = this.eventKey.substring(prevStr.length());
            }
        }
        this.ticket = requestMap.get("Ticket");
    }

    public String getEventKey() {
        return eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public String getTicket() {
        return ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }
}
