package cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.scan;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.base.EventReqMessage;

import java.util.Map;

/**
 * 扫描带参数二维码事件<br/>
 * 用户已关注时的事件推送<br/>
 * 如果用户已经关注公众号，则微信会将带场景值扫描事件推送给开发者。<br/>
 * 事件类型，SCAN
 */
public class ScanSubscribeYesMessage extends EventReqMessage {
    /**
     * 事件KEY值，是一个32位无符号整数，即创建二维码时的二维码scene_id
     */
    private String eventKey;
    /**
     * 二维码的ticket，可用来换取二维码图片
     */
    private String ticket;

    public ScanSubscribeYesMessage() {
    }

    public ScanSubscribeYesMessage(Map<String, String> requestMap) {
        super(requestMap);
        this.eventKey = requestMap.get("EventKey");
        this.ticket = requestMap.get("Ticket");
    }

    public String getEventKey() {
        return eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public String getTicket() {
        return ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }
}
