package cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain;

import cn.net.wanmo.common.charset.CharsetUtil;
import cn.net.wanmo.common.http.util.ResUtil;
import cn.net.wanmo.common.util.StringUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 基础消息能力 /接收普通消息 <br/>
 * 用户处理 腾讯公众号服务器 转发过来的消息请求
 */
public class ReqMessageUtil {
	private static Logger logger = LoggerFactory.getLogger(ReqMessageUtil.class);
	/**
	 * 解析微信发来的请求（XML）
	 *
	 * @param request
	 * @return map
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Map<String, String> parseXml2Map(HttpServletRequest request) throws Exception {
		return parseXml_2(request);
	}

	/**
	 * 解析微信发来的请求（XML）
	 *
	 * @param request
	 * @return map
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Map<String, String> parseXml_2(HttpServletRequest request) throws Exception {
		String requestXml = ResUtil.getResAsString(request.getInputStream(), CharsetUtil.UTF8_NAME);
		logger.debug("接收到腾讯公众号服务器的请求，从 request 解析 xml 开始： {}", requestXml);
		return parseXml2Map(requestXml);

	}

	/**
	 * 解析微信发来的请求（XML）
	 * 
	 * @param request
	 * @return map
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Map<String, String> parseXml_1(HttpServletRequest request) throws Exception {
		logger.debug("接收到腾讯公众号服务器的请求，从 request 解析 xml 开始");

		// 将解析结果存储在HashMap中
		Map<String, String> map = new HashMap<>();
		InputStream inputStream = null;
		try {
			// 从request中取得输入流
			inputStream = request.getInputStream();
			// 读取输入流
			SAXReader reader = new SAXReader();
			Document document = reader.read(inputStream);
			// 得到xml根元素
			Element root = document.getRootElement();
			// 得到根元素的所有子节点
			List<Element> elementList = root.elements();

			// 遍历所有子节点
			for (Element e : elementList) {
				if (e.isTextOnly()) {
					map.put(e.getName(), e.getText());
				} else {
					map.put(e.getName(), e.asXML());
				}
			}

		} catch (Exception e) {
			logger.debug("接收到腾讯公众号服务器的请求，从 request 解析 xml 异常：", e);
		} finally {
			// 释放资源
			if (inputStream != null) {
				inputStream.close();
			}
		}

		logger.debug("接收到腾讯公众号服务器的请求，从 request 解析 xml 结果：{}", JSON.toJSONString(map));
		return map;
	}

	/**
	 * 将 xml 字符串转为 json
	 *
	 * @param xml xml字符串
	 * @return map map 对象
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static JSONObject parseXml2Json(String xml) {
		logger.debug("解析 xml字符串为 json，处理开始： {}", xml);

		// 将解析结果存储在HashMap中
		JSONObject object = new JSONObject();
		try {
			if (StringUtil.isBlank(xml)) {
				return object;
			}

			// 读取输入流
			SAXReader reader = new SAXReader();
			Document document = reader.read(new ByteArrayInputStream(xml.getBytes("utf-8"))); // 读取xml字符串，注意这里要转成输入流
			// 得到xml根元素
			Element root = document.getRootElement();
			// 得到根元素的所有子节点
			List<Element> elementList = root.elements();

			elementToJson(object, elementList);

		} catch (Exception e) {
			logger.debug("解析 xml字符串为 json，处理异常：", e);
		}

		logger.debug("解析 xml字符串为 json，处理结果：{}", object.toJSONString());
		return object;
	}

	private static void elementToJson(JSONObject object, List<Element> elements) {
		for (Element element : elements) {
			if (element.isTextOnly()) {
				object.put(element.getName(), element.getText());
			} else {
				JSONObject objectTmp = new JSONObject();

				elementToJson(objectTmp, element.elements());
				object.put(element.getName(), objectTmp);
			}
		}
	}

	/**
	 * 将 xml 字符串转为 map
	 *
	 * @param xml xml字符串
	 * @return map map 对象
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Map<String, String> parseXml2Map(String xml) {
		logger.debug("解析 xml字符串为 map，处理开始： {}", xml);

		// 将解析结果存储在HashMap中
		Map<String, String> map = new HashMap<>();
		try {
			if (StringUtil.isBlank(xml)) {
				return map;
			}

			// 读取输入流
			SAXReader reader = new SAXReader();
			Document document = reader.read(new ByteArrayInputStream(xml.getBytes(CharsetUtil.UTF8_NAME))); // 读取xml字符串，注意这里要转成输入流
			// 得到xml根元素
			Element root = document.getRootElement();
			// 得到根元素的所有子节点
			List<Element> elementList = root.elements();

			// 遍历所有子节点
			for (Element e : elementList) {
				if (e.isTextOnly()) {
					map.put(e.getName(), e.getText());
				} else {
					map.put(e.getName(), e.asXML());
				}
			}

		} catch (Exception e) {
			logger.debug("解析 xml字符串为 map，处理异常：", e);
		}

		logger.debug("解析 xml字符串为 map，处理结果：{}", JSON.toJSONString(map));
		return map;
	}

	/**
	 * 将 xml 字符串转为 map
	 *
	 * @param xml xml字符串
	 * @return map map 对象
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static List<String> parseXml2List(String xml) {
		logger.debug("解析 xml字符串为 list，处理开始： {}", xml);

		// 将解析结果存储在HashMap中
		List<String> list = new ArrayList<>();
		try {
			if (StringUtil.isBlank(xml)) {
				return list;
			}

			// 读取输入流
			SAXReader reader = new SAXReader();
			Document document = reader.read(new ByteArrayInputStream(xml.getBytes("utf-8"))); // 读取xml字符串，注意这里要转成输入流
			// 得到xml根元素
			Element root = document.getRootElement();
			// 得到根元素的所有子节点
			List<Element> elementList = root.elements();

			// 遍历所有子节点
			for (Element e : elementList) {
				if (e.isTextOnly()) {
					list.add(e.getText());
				} else {
					list.add(e.asXML());
				}
//				Map<String, String> map = new HashMap<>();
//				if (e.isTextOnly()) { // list 集合为字符串， 非对象
//					map.put(e.getText(), e.getText());
//				} else { // list 集合是对象
//					List<Element> elements = e.elements();
//					for (Element element : elements) {
//
//					}
////					map.put(e.getName(), e.asXML());
//				}
			}

		} catch (Exception e) {
			logger.debug("解析 xml字符串为 list，处理异常：", e);
		}

		logger.debug("解析 xml字符串为 list，处理结果：{}", JSON.toJSONString(list));
		return list;
	}

}
