package cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.article.PlainResArticle;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.article.PlainResArticleMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.image.PlainResImageMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.music.PlainResMusicMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.text.PlainResTextMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.video.PlainResVideoMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.voice.PlainResVoiceMessage;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.URL;

/**
 * 基础消息能力 /被动回复用户消息
 */
public class ResMessageUtil {
    private static Logger logger = LoggerFactory.getLogger(ResMessageUtil.class);


    /**
     * 文本消息对象转换成 XML
     *
     * @param message 文本消息对象
     * @return XML
     */
    public static String textMessageToXml(PlainResTextMessage message) {
        xstream.alias("xml", message.getClass());
        return xstream.toXML(message);
    }

    /**
     * 图片消息对象转换成 XML
     *
     * @param message 文本消息对象
     * @return XML
     */
    public static String imageMessageToXml(PlainResImageMessage message) {
        xstream.alias("xml", message.getClass());
        return xstream.toXML(message);
    }

    /**
     * 语音消息对象转换成 XML
     *
     * @param message 文本消息对象
     * @return XML
     */
    public static String voiceMessageToXml(PlainResVoiceMessage message) {
        xstream.alias("xml", message.getClass());
        return xstream.toXML(message);
    }

    /**
     * 视频消息对象转换成 XML
     *
     * @param message 文本消息对象
     * @return XML
     */
    public static String videoMessageToXml(PlainResVideoMessage message) {
        xstream.alias("xml", message.getClass());
        return xstream.toXML(message);
    }

    /**
     * 音乐消息对象转换成 XML
     *
     * @param message 音乐消息对象
     * @return XML
     */
    public static String musicMessageToXml(PlainResMusicMessage message) {
        xstream.alias("xml", message.getClass());
        return xstream.toXML(message);
    }

    /**
     * 图文消息对象转换成 XML
     *
     * @param message 图文消息对象
     * @return XML
     */
    public static String articleMessageToXml(PlainResArticleMessage message) {
        xstream.alias("xml", message.getClass());
        xstream.alias("item", new PlainResArticle().getClass());
        return xstream.toXML(message);
    }


    /**
     * 扩展XStream，使其支持CDATA块
     */
    public static XStream xstream = new XStream(new HierarchicalStreamDriver() {

        @Override
        public HierarchicalStreamWriter createWriter(OutputStream arg0) {
            return null;
        }

        @Override
        public HierarchicalStreamWriter createWriter(Writer out) {
            return new PrettyPrintWriter(out) {
                @Override
                public void startNode(String name) {
                    if (StringUtil.equals(name, "xml")) {
                        // 节点名称 无需处理
                    } else {
                        // 节点名称 首字母大写
                        name = StringUtil.capitalize(name);
                    }
                    super.startNode(name);
                }


                @Override
                protected void writeText(QuickWriter writer, String text) {
                    boolean cdata = true;
                    if (cdata) {
                        writer.write("<![CDATA[");
                        writer.write(text);
                        writer.write("]]>");
                    } else {
                        writer.write(text);
                    }
                }

                ;
            };
        }

        @Override
        public HierarchicalStreamReader createReader(File arg0) {
            return null;
        }

        @Override
        public HierarchicalStreamReader createReader(URL arg0) {
            return null;
        }

        @Override
        public HierarchicalStreamReader createReader(InputStream arg0) {
            return null;
        }

        @Override
        public HierarchicalStreamReader createReader(Reader arg0) {
            return null;
        }
    });

    /**
     * 计算采用UTF-8编码方式时字符串所占字节数
     *
     * @param content
     * @return
     */
    public static int getByteSize(String content) {
        int size = 0;
        if (null != content) {
            try {
                // 汉字采用UTF-8编码时占3个字节
                size = content.getBytes("utf-8").length;
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return size;
    }
}
