package cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.text;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.ResMessageUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.ResMessageType;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.base.PlainResMessage;

import java.util.Objects;

/**
 * 文本消息
 */
public class PlainResTextMessage extends PlainResMessage {

	private PlainResText text;

	// 以下为方便 xml 组装
	private String content;


	public PlainResTextMessage(String toUserName, String fromUserName) {
		super(toUserName, fromUserName);
		this.msgType = ResMessageType.text;
	}

	@Override
	public String toXml() {
		return ResMessageUtil.textMessageToXml(this);
	}

	public PlainResText getText() {
		return text;
	}

	public void setText(PlainResText text) {
		this.text = text;

		if (Objects.nonNull(text)) {
			this.content = text.getContent();
		}
	}

}