package cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode.pojo.QrcodeCreateReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode.pojo.QrcodeCreateRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 账号管理 /生成带参数的二维码 <br/><br/>
 * 1、临时二维码，是有过期时间的，最长可以设置为在二维码生成后的30天（即2592000秒）后过期，但能够生成较多数量。临时二维码主要用于账号绑定等不要求二维码永久保存的业务场景<br/><br/>
 * 2、永久二维码，是无过期时间的，但数量较少（目前为最多10万个）。永久二维码主要用于适用于账号绑定、用户来源统计等场景<br/><br/>
 */
public class QrcodeUtil {
    private static Logger logger = LoggerFactory.getLogger(QrcodeUtil.class);


    public static InterfaceResult<QrcodeCreateRes> create(String logPrevDesc, String accessToken, QrcodeCreateReq req) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 生成带参数的二维码: ");

        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toJSONString());
        QrcodeCreateRes res = new QrcodeCreateRes();
        return SendUtil.sendPostForJson(msgPre, url, req, res, logger, Integer.class);
    }

}
