package cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode.pojo;

import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode.dto.ActionInfo;
import cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode.enums.ActionName;
import com.alibaba.fastjson2.JSONObject;

import java.util.Objects;

public class QrcodeCreateReq  extends Req {

    @Override
    public String toJSONString() {
        JSONObject jsonObject = new JSONObject();

        if (Objects.nonNull(this.expireSeconds)) {
            jsonObject.put("expire_seconds", this.expireSeconds);
        }
        if (Objects.nonNull(this.actionName)) {
            jsonObject.put("action_name", this.actionName.getValue());
        }
        if (Objects.nonNull(this.actionInfo)) {
            JSONObject actionInfo = new JSONObject();

            {
                JSONObject scene = new JSONObject();
                scene.put("scene_id", this.actionInfo.getScene().getSceneId());
                scene.put("scene_str", this.actionInfo.getScene().getSceneStr());
                actionInfo.put("scene", scene);
            }

            jsonObject.put("action_info", actionInfo);
        }


        return jsonObject.toJSONString();
    }

    /**
     * 该二维码有效时间，以秒为单位。 最大不超过2592000（即30天），此字段如果不填，则默认有效期为60秒。
     */
    private Integer expireSeconds;
    /**
     * 二维码类型，QR_SCENE为临时的整型参数值，QR_STR_SCENE为临时的字符串参数值，QR_LIMIT_SCENE为永久的整型参数值，QR_LIMIT_STR_SCENE为永久的字符串参数值
     */
    private ActionName actionName;
    /**
     * 二维码详细信息
     */
    private ActionInfo actionInfo;

    public QrcodeCreateReq() {
    }

    public Integer getExpireSeconds() {
        return expireSeconds;
    }

    public void setExpireSeconds(Integer expireSeconds) {
        this.expireSeconds = expireSeconds;
    }

    public ActionName getActionName() {
        return actionName;
    }

    public void setActionName(ActionName actionName) {
        this.actionName = actionName;
    }

    public ActionInfo getActionInfo() {
        return actionInfo;
    }

    public void setActionInfo(ActionInfo actionInfo) {
        this.actionInfo = actionInfo;
    }
}
