/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.officialaccount.core.service;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.MenuEventType;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.ReqEventType;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.account.AccountSubscribeMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.account.AccountUnsubscribeMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.location.ReportLocationMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu.MenuClickMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu.MenuLocationSelectMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu.MenuPicPhotoOrAlbumMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu.MenuPicSysphotoMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu.MenuPicWeixinMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu.MenuScancodePushMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu.MenuScancodeWaitmsgMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu.MenuViewMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu.MenuViewMiniprogramMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.scan.ScanSubscribeNoMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.scan.ScanSubscribeYesMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.ReqMessageUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.ReqMessageType;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.base.PlainReqMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.image.PlainReqImageMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.link.PlainReqLinkMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.location.PlainReqLocationMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.shortvideo.PlainReqShortVideoMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.text.PlainReqTextMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.video.PlainReqVideoMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.voice.PlainReqVoiceMessage;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CoreService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String token;

    public CoreService() {
        this.init();
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void init() {
    }

    public String processRequest(HttpServletRequest request) {
        String resXml = "success";
        try {
            this.logger.debug("==================== \u63a5\u6536\u5230\u817e\u8baf\u516c\u4f17\u53f7\u670d\u52a1\u5668\u7684\u8bf7\u6c42\uff0c\u5904\u7406\u5f00\u59cb ==================== ");
            Map<String, String> requestMap = ReqMessageUtil.parseXml2Map(request);
            ReqMessageType msgType = PlainReqMessage.getMsgType(requestMap);
            this.logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7 \u63a5\u6536\u666e\u901a\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)msgType);
            switch (msgType) {
                case text: {
                    this.logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7 \u5904\u7406\u666e\u901a\u6587\u672c\u6d88\u606f\u7c7b\u578b");
                    PlainReqTextMessage message = this.processTextMessage(requestMap);
                    resXml = message.getPlainResXml();
                    break;
                }
                case image: {
                    this.logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7 \u5904\u7406\u666e\u901a\u56fe\u7247\u6d88\u606f\u7c7b\u578b");
                    PlainReqImageMessage message = this.processImageMessage(requestMap);
                    resXml = message.getPlainResXml();
                    break;
                }
                case voice: {
                    this.logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7 \u5904\u7406\u666e\u901a\u97f3\u9891\u6d88\u606f\u7c7b\u578b");
                    PlainReqVoiceMessage message = this.processVoiceMessage(requestMap);
                    resXml = message.getPlainResXml();
                    break;
                }
                case video: {
                    this.logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7 \u5904\u7406\u666e\u901a\u89c6\u9891\u6d88\u606f\u7c7b\u578b");
                    PlainReqVideoMessage message = this.processVideoMessage(requestMap);
                    resXml = message.getPlainResXml();
                    break;
                }
                case shortvideo: {
                    this.logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7 \u5904\u7406\u666e\u901a\u77ed\u89c6\u9891\u6d88\u606f\u7c7b\u578b");
                    PlainReqShortVideoMessage message = this.processShortvideoMessage(requestMap);
                    resXml = message.getPlainResXml();
                    break;
                }
                case location: {
                    this.logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7 \u5904\u7406\u666e\u901a\u4f4d\u7f6e\u6d88\u606f\u7c7b\u578b");
                    PlainReqLocationMessage message = this.processLocationMessage(requestMap);
                    resXml = message.getPlainResXml();
                    break;
                }
                case link: {
                    this.logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7 \u5904\u7406\u666e\u901a\u94fe\u63a5\u6d88\u606f\u7c7b\u578b");
                    PlainReqLinkMessage message = this.processLinkMessage(requestMap);
                    resXml = message.getPlainResXml();
                    break;
                }
                case event: {
                    String eventType = requestMap.get("Event");
                    this.logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7 \u5904\u7406\u666e\u901a\u4e8b\u4ef6\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)eventType);
                    resXml = this.plainEvent(requestMap, eventType);
                    break;
                }
                default: {
                    this.logger.warn("\u5fae\u4fe1\u516c\u4f17\u53f7 \u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)msgType);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u6d88\u606f\u7c7b\u578b\u89e3\u6790\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
        }
        return resXml;
    }

    private String plainEvent(Map<String, String> requestMap, String eventType) {
        String resXml = "success";
        ReqEventType reqEventType = ReqEventType.convertOf(eventType);
        switch (reqEventType) {
            case subscribe: {
                String ticket = requestMap.get("Ticket");
                if (StringUtil.isBlank((CharSequence)ticket)) {
                    AccountSubscribeMessage message = this.processAccountSubscribeMessage(requestMap);
                    resXml = message.getPlainResXml();
                    break;
                }
                ScanSubscribeNoMessage message = this.processScanSubscribeNoMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case unsubscribe: {
                AccountUnsubscribeMessage message = this.processAccountUnsubscribeMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case SCAN: {
                ScanSubscribeYesMessage message = this.processScanSubscribeYesMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case LOCATION: {
                ReportLocationMessage message = this.processReportLocationMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            default: {
                resXml = this.menuEvent(requestMap, eventType);
            }
        }
        return resXml;
    }

    private String menuEvent(Map<String, String> requestMap, String eventType) {
        String resXml = "success";
        MenuEventType menuEventType = MenuEventType.convertOf(eventType);
        switch (menuEventType) {
            case CLICK: {
                MenuClickMessage message = this.processMenuClickMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case VIEW: {
                MenuViewMessage message = this.processMenuViewMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case view_miniprogram: {
                MenuViewMiniprogramMessage message = this.processMenuViewMiniprogramMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case location_select: {
                MenuLocationSelectMessage message = this.processMenuLocationSelectMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case scancode_push: {
                MenuScancodePushMessage message = this.processMenuScancodePushMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case scancode_waitmsg: {
                MenuScancodeWaitmsgMessage message = this.processMenuScancodeWaitmsgMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case pic_weixin: {
                MenuPicWeixinMessage message = this.processMenuPicWeixinMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case pic_sysphoto: {
                MenuPicSysphotoMessage message = this.processMenuPicSysphotoMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            case pic_photo_or_album: {
                MenuPicPhotoOrAlbumMessage message = this.processMenuPicPhotoOrAlbumMessage(requestMap);
                resXml = message.getPlainResXml();
                break;
            }
            default: {
                this.logger.warn("\u5fae\u4fe1\u516c\u4f17\u53f7 \u672a\u77e5\u7684\u4e8b\u4ef6\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)menuEventType);
            }
        }
        return resXml;
    }

    protected PlainReqTextMessage processTextMessage(Map<String, String> requestMap) {
        return new PlainReqTextMessage(requestMap);
    }

    protected PlainReqImageMessage processImageMessage(Map<String, String> requestMap) {
        return new PlainReqImageMessage(requestMap);
    }

    protected PlainReqVoiceMessage processVoiceMessage(Map<String, String> requestMap) {
        return new PlainReqVoiceMessage(requestMap);
    }

    protected PlainReqVideoMessage processVideoMessage(Map<String, String> requestMap) {
        return new PlainReqVideoMessage(requestMap);
    }

    protected PlainReqShortVideoMessage processShortvideoMessage(Map<String, String> requestMap) {
        return new PlainReqShortVideoMessage(requestMap);
    }

    protected PlainReqLocationMessage processLocationMessage(Map<String, String> requestMap) {
        return new PlainReqLocationMessage(requestMap);
    }

    protected PlainReqLinkMessage processLinkMessage(Map<String, String> requestMap) {
        return new PlainReqLinkMessage(requestMap);
    }

    protected AccountSubscribeMessage processAccountSubscribeMessage(Map<String, String> requestMap) {
        return new AccountSubscribeMessage(requestMap);
    }

    protected AccountUnsubscribeMessage processAccountUnsubscribeMessage(Map<String, String> requestMap) {
        return new AccountUnsubscribeMessage(requestMap);
    }

    protected ReportLocationMessage processReportLocationMessage(Map<String, String> requestMap) {
        return new ReportLocationMessage(requestMap);
    }

    protected ScanSubscribeNoMessage processScanSubscribeNoMessage(Map<String, String> requestMap) {
        return new ScanSubscribeNoMessage(requestMap);
    }

    protected ScanSubscribeYesMessage processScanSubscribeYesMessage(Map<String, String> requestMap) {
        return new ScanSubscribeYesMessage(requestMap);
    }

    protected MenuClickMessage processMenuClickMessage(Map<String, String> requestMap) {
        return new MenuClickMessage(requestMap);
    }

    protected MenuViewMessage processMenuViewMessage(Map<String, String> requestMap) {
        return new MenuViewMessage(requestMap);
    }

    protected MenuViewMiniprogramMessage processMenuViewMiniprogramMessage(Map<String, String> requestMap) {
        return new MenuViewMiniprogramMessage(requestMap);
    }

    protected MenuLocationSelectMessage processMenuLocationSelectMessage(Map<String, String> requestMap) {
        return new MenuLocationSelectMessage(requestMap);
    }

    protected MenuPicPhotoOrAlbumMessage processMenuPicPhotoOrAlbumMessage(Map<String, String> requestMap) {
        return new MenuPicPhotoOrAlbumMessage(requestMap);
    }

    protected MenuPicSysphotoMessage processMenuPicSysphotoMessage(Map<String, String> requestMap) {
        return new MenuPicSysphotoMessage(requestMap);
    }

    protected MenuPicWeixinMessage processMenuPicWeixinMessage(Map<String, String> requestMap) {
        return new MenuPicWeixinMessage(requestMap);
    }

    protected MenuScancodePushMessage processMenuScancodePushMessage(Map<String, String> requestMap) {
        return new MenuScancodePushMessage(requestMap);
    }

    protected MenuScancodeWaitmsgMessage processMenuScancodeWaitmsgMessage(Map<String, String> requestMap) {
        return new MenuScancodeWaitmsgMessage(requestMap);
    }

    protected void createMenu() {
    }
}

