/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.officialaccount.core.servlet;

import cn.net.wanmo.plugin.wechat.officialaccount.core.service.CoreService;
import cn.net.wanmo.plugin.wechat.officialaccount.core.util.SignUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CoreServlet.class);
    private static final long serialVersionUID = 4440739483644821986L;
    private CoreService coreService;

    public CoreService getCoreService() {
        return this.coreService;
    }

    public void setCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    public void init() throws ServletException {
        super.init();
        String coreServiceClass = this.getInitParameter("coreService");
        try {
            this.coreService = (CoreService)Class.forName(coreServiceClass).newInstance();
            logger.info("\u516c\u4f17\u53f7\u9a8c\u8bc1URL\u521d\u59cb\u5316\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u516c\u4f17\u53f7\u9a8c\u8bc1URL\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String signature = req.getParameter("signature");
        String timestamp = req.getParameter("timestamp");
        String nonce = req.getParameter("nonce");
        String echostr = req.getParameter("echostr");
        PrintWriter out = resp.getWriter();
        if (SignUtil.checkSignature(signature, this.coreService.getToken(), timestamp, nonce)) {
            logger.info("\u5fae\u4fe1\u516c\u4f17\u53f7\u9a8c\u8bc1URL\u9a8c\u7b7e\u6210\u529f");
            out.print(echostr);
        } else {
            logger.warn("\u5fae\u4fe1\u516c\u4f17\u53f7\u9a8c\u8bc1URL\u9a8c\u7b7e\u5931\u8d25");
        }
        out.close();
        out = null;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.debug("==================== \u63a5\u6536\u5230\u817e\u8baf\u516c\u4f17\u53f7\u670d\u52a1\u5668\u7684\u8bf7\u6c42\uff0c\u5904\u7406\u8fdb\u5165 ====================");
        req.setCharacterEncoding("UTF-8");
        resp.setCharacterEncoding("UTF-8");
        String respMessage = this.coreService.processRequest(req);
        logger.debug("\u63a5\u6536\u5230\u817e\u8baf\u516c\u4f17\u53f7\u670d\u52a1\u5668\u7684\u54cd\u5e94\uff1a{}", (Object)respMessage);
        PrintWriter out = resp.getWriter();
        out.print(respMessage);
        out.close();
    }

    public void destroy() {
        super.destroy();
    }
}

