/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.officialaccount.storage;

import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.common.util.Threads;
import cn.net.wanmo.plugin.wechat.officialaccount.storage.AccessTokenLog;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.AccessToken;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.AccessTokenRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.StableAccessTokenRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.TokenUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenStorage {
    private static Logger logger = LoggerFactory.getLogger(AccessTokenStorage.class);
    private static Map<String, AccessToken> tokenMap = new HashMap<String, AccessToken>();

    public static <MyAccessToken extends AccessToken> void putToken(String appId, MyAccessToken myAccessToken) {
        myAccessToken.storeToken();
        tokenMap.put(appId, myAccessToken);
    }

    public static AccessToken getToken(String appId) {
        return tokenMap.getOrDefault(appId, new AccessToken());
    }

    public static <MyAccessToken extends AccessToken> InterfaceResult<AccessTokenRes> initToken(String appId, String appSecret, MyAccessToken myAccessToken) {
        InterfaceResult<AccessTokenRes> result = TokenUtil.getAccessToken(appId, appSecret);
        if (BooleanUtil.isFalse((Boolean)result.isSuccess())) {
            return result;
        }
        AccessToken accessToken = ((AccessTokenRes)((Object)result.getData())).getAccessToken();
        if (Objects.isNull(myAccessToken)) {
            AccessTokenStorage.putToken(appId, accessToken);
        } else {
            myAccessToken.setToken(accessToken.getToken());
            myAccessToken.setExpiresIn(accessToken.getExpiresIn());
            AccessTokenStorage.putToken(appId, myAccessToken);
        }
        AccessTokenLog.put(appId, accessToken);
        return result;
    }

    public static <MyAccessToken extends AccessToken> void runThreadInitToken(final String appId, final String appSecret, final Integer residueSecond, final Integer waitSecond, final MyAccessToken myAccessToken) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            InterfaceResult<AccessTokenRes> result;
                            if ((result = AccessTokenStorage.initToken(appId, appSecret, myAccessToken)).isSuccess()) {
                                AccessToken accessToken = ((AccessTokenRes)((Object)result.getData())).getAccessToken();
                                String token = accessToken.getToken();
                                int expiresIn = accessToken.getExpiresIn();
                                logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u8bbf\u95ee\u4ee4\u724c \u6210\u529f\uff0cexpiresIn = {}\uff0c token = {}", new Object[]{appId, expiresIn, token});
                                Threads.sleep((long)((expiresIn - (residueSecond == null ? 30 : residueSecond)) * 1000));
                                continue;
                            }
                            logger.error("\u5fae\u4fe1\u516c\u4f17\u53f7ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u8bbf\u95ee\u4ee4\u724c \u5931\u8d25, errCode:{} errMsg:{}", new Object[]{appId, result.getCode(), result.getMsg()});
                            Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5fae\u4fe1\u516c\u4f17\u53f7ID: " + appId + ", \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u8bbf\u95ee\u4ee4\u724c \u5f02\u5e38", (Throwable)e);
                        Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public static <MyAccessToken extends AccessToken> InterfaceResult<StableAccessTokenRes> initStableAccessToken(String appId, String appSecret, MyAccessToken myAccessToken) {
        InterfaceResult<StableAccessTokenRes> result = TokenUtil.getStableAccessToken(appId, appSecret);
        if (BooleanUtil.isFalse((Boolean)result.isSuccess())) {
            return result;
        }
        AccessToken accessToken = ((StableAccessTokenRes)((Object)result.getData())).getAccessToken();
        if (Objects.isNull(myAccessToken)) {
            AccessTokenStorage.putToken(appId, accessToken);
        } else {
            myAccessToken.setToken(accessToken.getToken());
            myAccessToken.setExpiresIn(accessToken.getExpiresIn());
            AccessTokenStorage.putToken(appId, myAccessToken);
        }
        AccessTokenLog.put(appId, accessToken);
        return result;
    }

    public static <MyAccessToken extends AccessToken> void runThreadInitStableAccessToken(final String appId, final String appSecret, final Integer residueSecond, final Integer waitSecond, final MyAccessToken myAccessToken) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            InterfaceResult<StableAccessTokenRes> result;
                            if ((result = AccessTokenStorage.initStableAccessToken(appId, appSecret, myAccessToken)).isSuccess()) {
                                AccessToken accessToken = ((StableAccessTokenRes)((Object)result.getData())).getAccessToken();
                                String token = accessToken.getToken();
                                int expiresIn = accessToken.getExpiresIn();
                                logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u8bbf\u95ee\u4ee4\u724c \u6210\u529f\uff0cexpiresIn = {}\uff0c token = {}", new Object[]{appId, expiresIn, token});
                                Threads.sleep((long)((expiresIn - (residueSecond == null ? 30 : residueSecond)) * 1000));
                                continue;
                            }
                            logger.error("\u5fae\u4fe1\u516c\u4f17\u53f7ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u8bbf\u95ee\u4ee4\u724c \u5931\u8d25, errCode:{} errMsg:{}", new Object[]{appId, result.getCode(), result.getMsg()});
                            Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5fae\u4fe1\u516c\u4f17\u53f7ID: " + appId + ", \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u8bbf\u95ee\u4ee4\u724c \u5f02\u5e38", (Throwable)e);
                        Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }
}

