/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.officialaccount.storage;

import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.common.util.Threads;
import cn.net.wanmo.plugin.wechat.officialaccount.storage.JsapiTicketLog;
import cn.net.wanmo.plugin.wechat.officialaccount.util.jsapiticket.JsapiTicket;
import cn.net.wanmo.plugin.wechat.officialaccount.util.jsapiticket.JsapiTicketRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.jsapiticket.TicketUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsapiTicketStorage {
    private static Logger logger = LoggerFactory.getLogger(JsapiTicketStorage.class);
    private static Map<String, JsapiTicket> ticketMap = new HashMap<String, JsapiTicket>();

    public static <MyJsapiTicket extends JsapiTicket> void putTicket(String appId, MyJsapiTicket myJsapiTicket) {
        myJsapiTicket.storeTicket();
        ticketMap.put(appId, myJsapiTicket);
    }

    public static JsapiTicket getTicket(String appId) {
        return ticketMap.getOrDefault(appId, new JsapiTicket());
    }

    public static <MyJsapiTicket extends JsapiTicket> InterfaceResult<JsapiTicketRes> initTicket(String appId, String accessToken, MyJsapiTicket myJsapiTicket) {
        InterfaceResult<JsapiTicketRes> result = TicketUtil.getJsapiTicket("", accessToken);
        if (BooleanUtil.isFalse((Boolean)result.isSuccess())) {
            return result;
        }
        JsapiTicket jsapiTicket = ((JsapiTicketRes)((Object)result.getData())).getJsapiTicket();
        if (Objects.isNull(myJsapiTicket)) {
            JsapiTicketStorage.putTicket(appId, jsapiTicket);
        } else {
            myJsapiTicket.setTicket(jsapiTicket.getTicket());
            myJsapiTicket.setExpiresIn(jsapiTicket.getExpiresIn());
            JsapiTicketStorage.putTicket(appId, myJsapiTicket);
        }
        JsapiTicketLog.put(appId, jsapiTicket);
        return result;
    }

    public static <MyJsapiTicket extends JsapiTicket> void runThreadInitToken(final String appId, final String accessToken, final Integer residueSecond, final Integer waitSecond, final MyJsapiTicket myJsapiTicket) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            InterfaceResult<JsapiTicketRes> result;
                            if ((result = JsapiTicketStorage.initTicket(appId, accessToken, myJsapiTicket)).isSuccess()) {
                                JsapiTicket jsapiTicket = ((JsapiTicketRes)((Object)result.getData())).getJsapiTicket();
                                String ticket = jsapiTicket.getTicket();
                                int expiresIn = jsapiTicket.getExpiresIn();
                                logger.debug("\u5fae\u4fe1\u516c\u4f17\u53f7ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 jsapiTicket \u6210\u529f\uff0cexpiresIn = {}\uff0c ticket = {}", new Object[]{appId, expiresIn, ticket});
                                Threads.sleep((long)((expiresIn - (residueSecond == null ? 30 : residueSecond)) * 1000));
                                continue;
                            }
                            logger.error("\u5fae\u4fe1\u516c\u4f17\u53f7ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 jsapiTicket \u5931\u8d25, errCode:{} errMsg:{}", new Object[]{appId, result.getCode(), result.getMsg()});
                            Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5fae\u4fe1\u516c\u4f17\u53f7ID: " + appId + ", \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u8bbf\u95ee\u4ee4\u724c \u5f02\u5e38", (Throwable)e);
                        Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }
}

