/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.plugin.wechat.officialaccount.pojo.WechatRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.AccessTokenReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.AccessTokenRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.StableAccessTokenReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.StableAccessTokenRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtil
extends WechatRes {
    private static Logger logger = LoggerFactory.getLogger(TokenUtil.class);

    public static InterfaceResult<AccessTokenRes> getAccessToken(String appId, String appSecret) {
        AccessTokenReq req = AccessTokenReq.build(appId, appSecret);
        return TokenUtil.getAccessToken(null, req);
    }

    public static InterfaceResult<AccessTokenRes> getAccessToken(String logPrevDesc, AccessTokenReq req) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "\u5fae\u4fe1\u516c\u4f17\u53f7 \u83b7\u53d6\u8bbf\u95ee\u4ee4\u724c: ");
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
        url = url.replace("APPID", req.getAppId()).replace("APPSECRET", req.getAppSecret());
        AccessTokenRes res = new AccessTokenRes();
        return SendUtil.sendGet((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static InterfaceResult<StableAccessTokenRes> getStableAccessToken(String appId, String appSecret) {
        StableAccessTokenReq req = StableAccessTokenReq.build(appId, appSecret);
        return TokenUtil.getStableAccessToken(null, req);
    }

    public static InterfaceResult<StableAccessTokenRes> getStableAccessToken(String logPrevDesc, StableAccessTokenReq req) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "\u5fae\u4fe1\u516c\u4f17\u53f7 \u83b7\u53d6\u7a33\u5b9a\u7248\u63a5\u53e3\u8c03\u7528\u51ed\u636e: ");
        String url = "https://api.weixin.qq.com/cgi-bin/stable_token";
        req.setBody(req.toJSONString());
        StableAccessTokenRes res = new StableAccessTokenRes();
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }
}

