/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.officialaccount.util.jsapiticket;

import com.alibaba.fastjson2.JSON;
import java.security.MessageDigest;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsSignUtil {
    private static Logger logger = LoggerFactory.getLogger(JsSignUtil.class);

    public static Map<String, String> sign(String jsapi_ticket, HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        return JsSignUtil.sign(jsapi_ticket, url, false);
    }

    public static Map<String, String> sign(String jsapi_ticket, HttpServletRequest request, boolean toHttps) {
        String url = request.getRequestURL().toString();
        return JsSignUtil.sign(jsapi_ticket, url, toHttps);
    }

    public static Map<String, String> sign(String jsapi_ticket, String url, boolean toHttps) {
        HashMap<String, String> ret = new HashMap<String, String>();
        logger.debug("\u751f\u6210 wx.config \u9700\u8981\u7684\u6570\u636e jsapi_ticket : {}", (Object)jsapi_ticket);
        logger.debug("\u751f\u6210 wx.config \u9700\u8981\u7684\u6570\u636e url : {}", (Object)url);
        if (toHttps && url.startsWith("http://")) {
            url = url.replace("http://", "https://");
            logger.debug("\u751f\u6210 wx.config \u9700\u8981\u7684\u6570\u636e url \u5f3a\u8f6c\u4e3a https\u534f\u8bae : {}", (Object)url);
        }
        try {
            String nonce_str = JsSignUtil.create_nonce_str();
            String timestamp = JsSignUtil.create_timestamp();
            String string1 = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonce_str + "&timestamp=" + timestamp + "&url=" + url;
            String signature = "";
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes("UTF-8"));
            signature = JsSignUtil.byteToHex(crypt.digest());
            logger.debug("\u751f\u6210 wx.config \u9700\u8981\u7684\u6570\u636e signature : {}", (Object)signature);
            ret.put("url", url);
            ret.put("jsapi_ticket", jsapi_ticket);
            ret.put("nonceStr", nonce_str);
            ret.put("timestamp", timestamp);
            ret.put("signature", signature);
        }
        catch (Exception e) {
            ret.put("exception", e.getMessage());
            logger.error("\u751f\u6210 wx.config \u9700\u8981\u7684\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        logger.debug("\u751f\u6210 wx.config \u9700\u8981\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(ret));
        return ret;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    private static String create_nonce_str() {
        return UUID.randomUUID().toString();
    }

    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }
}

