/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.plugin.wechat.officialaccount.util.menu.pojo;

import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.ObjectUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.MenuButtonType;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.Menu;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.ArticleIdButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.ArticleViewLimitedButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.Button;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.ClickButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.LocationSelectButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.MediaIdButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.MiniprogramButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.PicPhotoOrAlbumButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.PicSysphotoButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.PicWeixinButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.ScancodePushButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.ScancodeWaitmsgButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.ViewButton;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button.ViewLimitedButton;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;

public class MenuCreateReq
extends Req {
    private Menu menu = new Menu();

    public static MenuCreateReq build(Menu menu) {
        MenuCreateReq req = new MenuCreateReq();
        req.setMenu(menu);
        return req;
    }

    public String toJSONString() {
        JSONArray buttonArray = new JSONArray();
        for (Button button : this.menu.getButtons()) {
            JSONObject buttonJson = this.byType(button.getType(), button);
            if (CollectionUtil.isNotEmpty(button.getSubButton())) {
                JSONArray arraySub = new JSONArray();
                for (Button buttonSub : button.getSubButton()) {
                    arraySub.add((Object)this.byType(buttonSub.getType(), buttonSub));
                }
                buttonJson.put((Object)"sub_button", (Object)arraySub);
            }
            buttonArray.add((Object)buttonJson);
        }
        return JSONObject.of((String)"button", (Object)buttonArray).toJSONString(new JSONWriter.Feature[0]);
    }

    private JSONObject byType(MenuButtonType type, Button button) {
        JSONObject object = new JSONObject();
        object.put((Object)"type", (Object)button.getType().getValue());
        object.put((Object)"name", (Object)button.getName());
        switch (type) {
            case click: {
                ClickButton b = (ClickButton)ObjectUtil.cast((Object)button);
                object.put((Object)"key", (Object)b.getKey());
                break;
            }
            case view: {
                ViewButton b = (ViewButton)ObjectUtil.cast((Object)button);
                object.put((Object)"url", (Object)b.getUrl());
                break;
            }
            case miniprogram: {
                MiniprogramButton b = (MiniprogramButton)ObjectUtil.cast((Object)button);
                object.put((Object)"url", (Object)b.getUrl());
                object.put((Object)"appid", (Object)b.getAppid());
                object.put((Object)"pagepath", (Object)b.getPagePath());
                break;
            }
            case scancode_push: {
                ScancodePushButton b = (ScancodePushButton)ObjectUtil.cast((Object)button);
                object.put((Object)"key", (Object)b.getKey());
                break;
            }
            case scancode_waitmsg: {
                ScancodeWaitmsgButton b = (ScancodeWaitmsgButton)ObjectUtil.cast((Object)button);
                object.put((Object)"key", (Object)b.getKey());
                break;
            }
            case pic_sysphoto: {
                PicSysphotoButton b = (PicSysphotoButton)ObjectUtil.cast((Object)button);
                object.put((Object)"key", (Object)b.getKey());
                break;
            }
            case pic_photo_or_album: {
                PicPhotoOrAlbumButton b = (PicPhotoOrAlbumButton)ObjectUtil.cast((Object)button);
                object.put((Object)"key", (Object)b.getKey());
                break;
            }
            case pic_weixin: {
                PicWeixinButton b = (PicWeixinButton)ObjectUtil.cast((Object)button);
                object.put((Object)"key", (Object)b.getKey());
                break;
            }
            case location_select: {
                LocationSelectButton b = (LocationSelectButton)ObjectUtil.cast((Object)button);
                object.put((Object)"key", (Object)b.getKey());
                break;
            }
            case media_id: {
                MediaIdButton b = (MediaIdButton)ObjectUtil.cast((Object)button);
                object.put((Object)"media_id", (Object)b.getMediaId());
                break;
            }
            case view_limited: {
                ViewLimitedButton b = (ViewLimitedButton)ObjectUtil.cast((Object)button);
                object.put((Object)"media_id", (Object)b.getMediaId());
                break;
            }
            case article_id: {
                ArticleIdButton b = (ArticleIdButton)ObjectUtil.cast((Object)button);
                object.put((Object)"article_id", (Object)b.getArticleId());
                break;
            }
            case article_view_limited: {
                ArticleViewLimitedButton b = (ArticleViewLimitedButton)ObjectUtil.cast((Object)button);
                object.put((Object)"article_id", (Object)b.getArticleId());
                break;
            }
            default: {
                object.remove((Object)"type");
            }
        }
        return object;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }
}

