package cn.net.wanmo.plugin.wechat.officialaccount.storage;

import cn.net.wanmo.plugin.wechat.officialaccount.util.jsapiticket.JsapiTicket;
import com.google.common.collect.Lists;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsapiTicketLog {
    /**
     * 令牌的记录 <br/>
     */
    public static Map<String, List<JsapiTicket>> map = new HashMap<>();

    /**
     * 每个令牌类型保存日志的最多个数
     */
    private static int maxSize = 30;


    /**
     * 获取令牌日志
     *
     * @param appId    企业ID
     * @return 日志集合
     */
    public static List<JsapiTicket> get(String appId) {
        List<JsapiTicket> list = map.getOrDefault(appId, Lists.newArrayList());
        Collections.reverse(list);
        return list;
    }


    /**
     * 添加 token 日志;
     *
     * @param appId    企业ID
     * @param jsapiTicket       待保存的令牌
     */
    public static void put(String appId, JsapiTicket jsapiTicket) {
        List<JsapiTicket> list = map.getOrDefault(appId, Lists.newArrayList());

        { // 添加日志
            list.add(jsapiTicket);
        }

        { // 日志数量控制
            int size = list.size();
            for (int i = 0; i < size - maxSize; i++) {
                list.remove(0);
            }
        }

        map.put(appId, list);
    }

}
