package cn.net.wanmo.plugin.wechat.officialaccount.util.menu;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.pojo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuUtil {
    private static Logger logger = LoggerFactory.getLogger(MenuUtil.class);

    /**
     * 自定义菜单 /创建接口 <br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param accessToken 访问令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<MenuCreateRes> menuCreate(String logPrevDesc, String accessToken, MenuCreateReq req) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 自定义菜单 创建接口: ");

        String url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);


//        String basePath = "https://baidu.com/";
//        String jsonMenu = "{\"button\":[{\"type\":\"view\",\"name\":\"教师考评\",\"url\":\"" + basePath
//                + "f/teacher\"},{\"type\":\"view\",\"name\":\"社会评价\",\"url\":\"" + basePath + "f/society\"}]}";
//        req.setBody(jsonMenu);

        req.setBody(req.toJSONString());
        MenuCreateRes res = new MenuCreateRes();
        return SendUtil.sendPostForJson(msgPre, url, req, res, logger, Integer.class);
    }

    /**
     * 自定义菜单 /删除接口<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static InterfaceResult<MenuDeleteRes> menuDelete(String logPrevDesc, String accessToken) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 自定义菜单 删除接口: ");

        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        MenuDeleteReq req = MenuDeleteReq.build();
        MenuDeleteRes res = new MenuDeleteRes();
        return SendUtil.sendGet(msgPre, url, req, res, logger, Integer.class);
    }


    /**
     * 公众号当前使用的自定义菜单的配置<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static InterfaceResult<GetCurrentSelfmenuInfoRes> getCurrentSelfmenuInfo(String logPrevDesc, String accessToken) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 公众号当前使用的自定义菜单的配置: ");

        String url = "https://api.weixin.qq.com/cgi-bin/get_current_selfmenu_info?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        GetCurrentSelfmenuInfoReq req = GetCurrentSelfmenuInfoReq.build();
        GetCurrentSelfmenuInfoRes res = new GetCurrentSelfmenuInfoRes();
        return SendUtil.sendGet(msgPre, url, req, res, logger, Integer.class);
    }

    // todo 自定义菜单 /个性化菜单接口 待实现
    // todo 自定义菜单 /获取自定义菜单配置 待实现
}
