package cn.net.wanmo.plugin.wechat.officialaccount.util.menu.dto.button;

import cn.net.wanmo.plugin.wechat.officialaccount.util.menu.MenuButtonType;

/**
 * 小程序
 */
public class MiniprogramButton extends Button {
    /**
     * miniprogram类型必须	小程序的appid（仅认证公众号可配置）
     */
    private String appid;
    /**
     * miniprogram类型必须	小程序的页面路径
     */
    private String pagePath;
    /**
     * view、miniprogram类型必须	网页 链接，用户点击菜单可打开链接，不超过1024字节。 type为miniprogram时，不支持小程序的老版本客户端将打开本url。
     */
    private String url;

    public MiniprogramButton() {
        super();
        this.type = MenuButtonType.miniprogram;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getPagePath() {
        return pagePath;
    }

    public void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
