package cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.base.EventReqMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.ReqMessageUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 点击菜单拉取消息时的事件推送<br/>
 * 弹出系统拍照发图的事件推送<br/>
 * 事件类型，pic_sysphoto
 */
public class MenuPicSysphotoMessage extends EventReqMessage {

    /**
     * 点击菜单跳转链接时的事件推送: 事件KEY值，与自定义菜单接口中KEY值对应 <br/>
     */
    private String eventKey;
    /**
     * 发送的图片信息
     */
    private SendPicsInfo sendPicsInfo = new SendPicsInfo();

    public MenuPicSysphotoMessage() {
    }

    public MenuPicSysphotoMessage(Map<String, String> requestMap) {
        super(requestMap);
        this.eventKey = requestMap.get("EventKey");
        {
            String sendPicsInfoXml = requestMap.getOrDefault("SendPicsInfo", "");
            Map<String, String> sendPicsInfoMap = ReqMessageUtil.parseXml2Map(sendPicsInfoXml);
            { // 图片数量
                this.sendPicsInfo.count = Integer.valueOf(sendPicsInfoMap.get("Count"));
            }

            { // 图片集合
                String picListXml = sendPicsInfoMap.getOrDefault("PicList", "");
                List<String> picList = ReqMessageUtil.parseXml2List(picListXml);
                for (String picXml : picList) {
                    Map<String, String> picMap = ReqMessageUtil.parseXml2Map(picXml);

                    SendPicsInfoItem item = new SendPicsInfoItem();
                    item.setPicMd5Sum(picMap.get("PicMd5Sum"));

                    this.sendPicsInfo.items.add(item);
                }
            }
        }
    }

    public String getEventKey() {
        return eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public SendPicsInfo getSendPicsInfo() {
        return sendPicsInfo;
    }

    public void setSendPicsInfo(SendPicsInfo sendPicsInfo) {
        this.sendPicsInfo = sendPicsInfo;
    }

    /**
     * 发送的图片信息
     */
    public class SendPicsInfo{
        /**
         * 发送的图片数量
         */
        private int count;
        /**
         * 图片列表
         */
        private List<SendPicsInfoItem> items = new ArrayList<>();

        public SendPicsInfo() {
        }

        public int getCount() {
            return count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public List<SendPicsInfoItem> getItems() {
            return items;
        }

        public void setItems(List<SendPicsInfoItem> items) {
            this.items = items;
        }
    }

    public class SendPicsInfoItem{
        /**
         * 图片的MD5值，开发者若需要，可用于验证接收到图片
         */
        private String picMd5Sum;

        public SendPicsInfoItem() {
        }

        public String getPicMd5Sum() {
            return picMd5Sum;
        }

        public void setPicMd5Sum(String picMd5Sum) {
            this.picMd5Sum = picMd5Sum;
        }
    }
}
