package cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.base.EventReqMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.ReqMessageUtil;

import java.util.Map;

/**
 * 点击菜单拉取消息时的事件推送<br/>
 * 扫码推事件且弹出“消息接收中”提示框的事件推送<br/>
 * 事件类型，scancode_waitmsg
 */
public class MenuScancodeWaitmsgMessage extends EventReqMessage {

    /**
     * 点击菜单跳转链接时的事件推送: 事件KEY值，与自定义菜单接口中KEY值对应 <br/>
     */
    private String eventKey;
    /**
     * 扫描信息
     */
    private ScanCodeInfo scanCodeInfo = new ScanCodeInfo();

    public MenuScancodeWaitmsgMessage() {
    }

    public MenuScancodeWaitmsgMessage(Map<String, String> requestMap) {
        super(requestMap);
        this.eventKey = requestMap.get("EventKey");
        {
            String infoXml = requestMap.getOrDefault("ScanCodeInfo", "");
            Map<String, String> parseXml = ReqMessageUtil.parseXml2Map(infoXml);
            this.scanCodeInfo.scanType = parseXml.get("ScanType");
            this.scanCodeInfo.scanResult = parseXml.get("ScanResult");
        }
    }

    public String getEventKey() {
        return eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public ScanCodeInfo getScanCodeInfo() {
        return scanCodeInfo;
    }

    public void setScanCodeInfo(ScanCodeInfo scanCodeInfo) {
        this.scanCodeInfo = scanCodeInfo;
    }

    /**
     * 扫描信息
     */
    public class ScanCodeInfo {
        /**
         * 扫描类型，一般是qrcode
         */
        private String scanType;
        /**
         * 扫描结果，即二维码对应的字符串信息
         */
        private String scanResult;

        public ScanCodeInfo() {
        }

        public String getScanType() {
            return scanType;
        }

        public void setScanType(String scanType) {
            this.scanType = scanType;
        }

        public String getScanResult() {
            return scanResult;
        }

        public void setScanResult(String scanResult) {
            this.scanResult = scanResult;
        }
    }
}
