package cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res;

import cn.net.wanmo.common.util.StringUtil;

/**
 * 公众号响应消息类型
 */
public enum ResMessageType {
    unknown("unknown", "未知类型"),
    text("text", "文本消息"),
    image("image", "图片消息"),
    voice("voice", "语音消息"),
    video("video", "视频消息"),
    music("music", "音乐消息"),
    news("news", "图文消息"),
    ;

    private final String value;
    private final String label;

    ResMessageType(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }

    public static ResMessageType convertOf(String value) {
        ResMessageType r = ResMessageType.unknown;

        for (ResMessageType type : values()) {
            if (StringUtil.equals(value, type.getValue())) {
                r = type;
                break;
            }
        }

        return r;
    }
}
