package cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.base;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.res.ResMessageType;

import java.util.Date;

/**
 * 消息基类（公众帐号 -> 普通用户）
 */
public abstract class PlainResMessage {

	protected ResMessageType msgType;
	protected String toUserName;
	protected String fromUserName;
	protected long createTime;
	protected int funcFlag;

	public PlainResMessage() {
		super();
		this.msgType = ResMessageType.unknown;
	}

	public PlainResMessage(String toUserName, String fromUserName) {
		this();

		this.toUserName = toUserName;
		this.fromUserName = fromUserName;
		this.createTime = new Date().getTime();
		this.funcFlag = 0;
	}

	public String getToUserName() {
		return toUserName;
	}

	public void setToUserName(String toUserName) {
		this.toUserName = toUserName;
	}

	public String getFromUserName() {
		return fromUserName;
	}

	public void setFromUserName(String fromUserName) {
		this.fromUserName = fromUserName;
	}

	public long getCreateTime() {
		return createTime;
	}

	public void setCreateTime(long createTime) {
		this.createTime = createTime;
	}

	public ResMessageType getMsgType() {
		return msgType;
	}

	public void setMsgType(ResMessageType msgType) {
		this.msgType = msgType;
	}

	public int getFuncFlag() {
		return funcFlag;
	}

	public void setFuncFlag(int funcFlag) {
		this.funcFlag = funcFlag;
	}

	public abstract String toXml();
}
