package cn.net.wanmo.plugin.wechat.officialaccount.util.message.template;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.template.pojo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 消息模板工具类
 */
public class TemplateUtil {
    private static Logger logger = LoggerFactory.getLogger(TemplateUtil.class);

    /**
     * 设置所属行业<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param accessToken 访问令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<ApiSetIndustryRes> apiSetIndustry(String logPrevDesc, String accessToken, ApiSetIndustryReq req) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 设置所属行业: ");

        String url = "https://api.weixin.qq.com/cgi-bin/template/api_set_industry?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toJSONString());
        ApiSetIndustryRes res = new ApiSetIndustryRes();
        return SendUtil.sendPostForJson(msgPre, url, req, res, logger, Integer.class);
    }


    /**
     * 获取账号设置的行业信息<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static InterfaceResult<GetIndustryRes> getIndustry(String logPrevDesc, String accessToken) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 获取账号设置的行业信息: ");

        String url = "https://api.weixin.qq.com/cgi-bin/template/get_industry?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        GetIndustryReq req = GetIndustryReq.build();
        GetIndustryRes res = new GetIndustryRes();
        return SendUtil.sendGet(msgPre, url, req, res, logger, Integer.class);
    }


    /**
     * 获得模板ID<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param accessToken 访问令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<ApiAddPrivateTemplateRes> apiAddTemplate(String logPrevDesc, String accessToken, ApiAddPrivateTemplateReq req) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 获得模板ID: ");

        String url = "https://api.weixin.qq.com/cgi-bin/template/api_add_template?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toJSONString());
        ApiAddPrivateTemplateRes res = new ApiAddPrivateTemplateRes();
        return SendUtil.sendPostForJson(msgPre, url, req, res, logger, Integer.class);
    }

    /**
     * 获取账号下所有模板信息<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static InterfaceResult<GetAllPrivateTemplateRes> getAllPrivateTemplate(String logPrevDesc, String accessToken) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 获取账号下所有模板信息: ");

        String url = "https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        GetAllPrivateTemplateReq req = GetAllPrivateTemplateReq.build();
        GetAllPrivateTemplateRes res = new GetAllPrivateTemplateRes();
        return SendUtil.sendGet(msgPre, url, req, res, logger, Integer.class);
    }


    /**
     * 删除消息模板<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param accessToken 访问令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<DelPrivateTemplateRes> delPrivateTemplate(String logPrevDesc, String accessToken, DelPrivateTemplateReq req) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 删除消息模板: ");

        String url = "https://api.weixin.qq.com/cgi-bin/template/del_private_template?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toJSONString());
        DelPrivateTemplateRes res = new DelPrivateTemplateRes();
        return SendUtil.sendPostForJson(msgPre, url, req, res, logger, Integer.class);
    }

    /**
     * 发送模板消息<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param accessToken 访问令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<SendPrivateTemplateRes> sendPrivateTemplate(String logPrevDesc, String accessToken, SendPrivateTemplateReq req) {
        String msgPre = CommonUtil.getMsgPre(logPrevDesc, "微信公众号 发送模板消息: ");

        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toJSONString());
        SendPrivateTemplateRes res = new SendPrivateTemplateRes();
        return SendUtil.sendPostForJson(msgPre, url, req, res, logger, Integer.class);
    }

}
