package cn.net.wanmo.plugin.wechat.officialaccount.util.message.template.pojo;

import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.pojo.WechatRes;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class GetAllPrivateTemplateRes extends WechatRes {
    @Override
    public Res parseObj(String resBody) {
        if (BooleanUtil.isFalse(isOk())) {
            return this;
        }

        JSONObject jsonObject = JSONObject.parseObject(resBody);

        { // 消息模板列表
            JSONArray templateList = jsonObject.getJSONArray("template_list");
            parseTemplateList(templateList);
        }

        return super.parseObj(resBody);
    }


    /**
     * 解析消息模板列表
     * @param templateList 消息模板列表
     */
    private void parseTemplateList(JSONArray templateList) {
        for (Object o : templateList) {
            JSONObject jsonObject = JSONObject.from(o);
            TemplateObj templateObj = new TemplateObj();

            {
                templateObj.setTemplateId(jsonObject.getString("template_id"));
                templateObj.setTitle(jsonObject.getString("title"));
                templateObj.setPrimaryIndustry(jsonObject.getString("primary_industry"));
                templateObj.setDeputyIndustry(jsonObject.getString("deputy_industry"));
                templateObj.setContent(jsonObject.getString("content"));
                templateObj.setExample(jsonObject.getString("example"));
            }

            list.add(templateObj);
        }
    }


    // ========================================================================

    private List<TemplateObj> list = new ArrayList<>();

    public GetAllPrivateTemplateRes() {
    }

    public List<TemplateObj> getList() {
        return list;
    }

    public void setList(List<TemplateObj> list) {
        this.list = list;
    }

    /**
     * 消息模板对象
     */
    public class TemplateObj {
        /**
         * 模板ID
         */
        private String templateId;
        /**
         * 模板标题
         */
        private String title;
        /**
         * 模板所属行业的一级行业
         */
        private String primaryIndustry;
        /**
         * 模板所属行业的二级行业
         */
        private String deputyIndustry;
        /**
         * 模板内容
         */
        private String content;
        /**
         * 模板示例
         */
        private String example;

        public TemplateObj() {
        }

        public String getTemplateId() {
            return templateId;
        }

        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getPrimaryIndustry() {
            return primaryIndustry;
        }

        public void setPrimaryIndustry(String primaryIndustry) {
            this.primaryIndustry = primaryIndustry;
        }

        public String getDeputyIndustry() {
            return deputyIndustry;
        }

        public void setDeputyIndustry(String deputyIndustry) {
            this.deputyIndustry = deputyIndustry;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getExample() {
            return example;
        }

        public void setExample(String example) {
            this.example = example;
        }
    }


}
