package cn.net.wanmo.plugin.wechat.officialaccount.util.message.template.pojo;

import cn.net.wanmo.common.restful.body.Req;
import com.alibaba.fastjson2.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SendPrivateTemplateReq extends Req {
    @Override
    public String toJSONString() {
        JSONObject req = new JSONObject();

        req.put("touser", this.toUser);
        req.put("template_id", this.templateId);
        req.put("url", this.url);

        if (Objects.nonNull(this.miniprogram)) { // 跳转小程序所需数据
            JSONObject miniprogram = new JSONObject();
            miniprogram.put("appid", this.miniprogram.appid);
            miniprogram.put("pagepath", this.miniprogram.pagePath);

            req.put("miniprogram", miniprogram);
        }

        req.put("client_msg_id", this.clientMsgId);

        { // 模板数据
            JSONObject data = new JSONObject();
            this.data.forEach((key, paramData) -> {
                JSONObject keyword = new JSONObject();
                keyword.put("value", paramData.value);

                data.put(key, keyword);
            });

            req.put("data", data);
        }

        return req.toJSONString();
    }

    // ===============================================================

    /**
     * 是	接收者openid
     */
    private String toUser;
    /**
     * 是	模板ID
     */
    private String templateId;
    /**
     * 否	模板跳转链接（海外账号没有跳转能力）
     */
    private String url;
    /**
     * 否	跳小程序所需数据，不需跳小程序可不用传该数据
     */
    private Miniprogram miniprogram = new Miniprogram();
    /**
     * 否	防重入id。对于同一个openid + client_msg_id, 只发送一条消息,10分钟有效,超过10分钟不保证效果。若无防重入需求，可不填
     */
    private String clientMsgId;
    /**
     * 是	模板数据
     */
    private Map<String, ParamData> data = new HashMap<>();


    public SendPrivateTemplateReq() {
    }

    public String getToUser() {
        return toUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Miniprogram getMiniprogram() {
        return miniprogram;
    }

    public void setMiniprogram(Miniprogram miniprogram) {
        this.miniprogram = miniprogram;
    }

    public String getClientMsgId() {
        return clientMsgId;
    }

    public void setClientMsgId(String clientMsgId) {
        this.clientMsgId = clientMsgId;
    }

    public Map<String, ParamData> getData() {
        return data;
    }

    public void setData(Map<String, ParamData> data) {
        this.data = data;
    }

    /**
     * 跳小程序所需数据
     */
    public class Miniprogram {
        /**
         * 是	所需跳转到的小程序appid（该小程序appid必须与发模板消息的公众号是绑定关联关系，暂不支持小游戏）
         */
        private String appid;
        /**
         * 否	所需跳转到小程序的具体页面路径，支持带参数,（示例index?foo=bar），要求该小程序已发布，暂不支持小游戏
         */
        private String pagePath;

        public Miniprogram() {
        }

        public String getAppid() {
            return appid;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public String getPagePath() {
            return pagePath;
        }

        public void setPagePath(String pagePath) {
            this.pagePath = pagePath;
        }
    }

    /**
     * 模板数据
     */
    public static class ParamData {
        private String value;

        public ParamData() {
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
