package cn.net.wanmo.plugin.wechat.officialaccount.core.servlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.net.wanmo.plugin.wechat.officialaccount.core.service.CoreService;
import cn.net.wanmo.plugin.wechat.officialaccount.core.util.SignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 配置该 servlet ， 公众号配置的URL地址就是该 servlet
 */
public class CoreServlet extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CoreServlet.class);

    private static final long serialVersionUID = 4440739483644821986L;

    private CoreService coreService;

    public CoreServlet() {
        super();
    }

    public CoreService getCoreService() {
        return coreService;
    }

    public void setCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    @Override
    public void init() throws ServletException {
        super.init();
        String coreServiceClass = this.getInitParameter("coreService");
        try {
            coreService = (CoreService) Class.forName(coreServiceClass).newInstance();
            logger.info("公众号验证URL初始化成功");
        } catch (Exception e) {
            logger.error("公众号验证URL初始化异常", e);
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.debug("==================== 验证到腾讯公众号服务器的请求，处理进入 ====================");
        // 微信加密签名
        String signature = req.getParameter("signature");
        // 时间戳
        String timestamp = req.getParameter("timestamp");
        // 随机数
        String nonce = req.getParameter("nonce");
        // 随机字符串
        String echostr = req.getParameter("echostr");
        // 自定义 用作生成签名
        String token = coreService.getToken();

        PrintWriter out = resp.getWriter();
        // 通过检验signature对请求进行校验，若校验成功则原样返回echostr，表示接入成功，否则接入失败
        if (SignUtil.checkSignature(signature, token, timestamp, nonce)) {
            logger.info("微信公众号验证URL验签成功");
            out.print(echostr);
        } else {
            logger.warn("微信公众号验证URL验签失败");
        }
        out.close();
        out = null;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.debug("==================== 接收到腾讯公众号服务器的请求，处理进入 ====================");
        // 将请求、响应的编码均设置为UTF-8（防止中文乱码）
        req.setCharacterEncoding("UTF-8");
        resp.setCharacterEncoding("UTF-8");

        // 调用核心业务类接收消息、处理消息
        String respMessage = coreService.processRequest(req);
        logger.debug("接收到腾讯公众号服务器的响应：{}", respMessage);
        // 响应消息
        PrintWriter out = resp.getWriter();
        out.print(respMessage);
        out.close();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

}
