package cn.net.wanmo.plugin.wechat.officialaccount.pojo;

import cn.net.wanmo.common.http.jdk.enums.Header;
import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.common.send.BodyType;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSON;

public class WechatBaseRes<Data> extends BaseRes<Integer, Data> {

    @Override
    protected void initData() {

    }

    public WechatBaseRes() {
        super();
        this.bodyType = BodyType.obj;
    }

    @Override
    public BaseRes parseCodeMsg(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);
        this.errCode = object.getIntValue("errcode");
        this.errMsg = object.getString("errmsg");

        return this;
    }


    @Override
    public Integer successDataCode() {
        return 0;
    }

    @Override
    public boolean isSuccessData() {
        return successDataCode().intValue() == getErrCode().intValue();
    }


    @Override
    public String toJSONString() {
        return JSON.toJSONString(this);
    }

    public String getContentType() {
        return getHeaderField(Header.CONTENT_TYPE.getValue());
    }
}
