package cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.pojo.AccessTokenReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.pojo.AccessTokenRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.pojo.StableAccessTokenReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.pojo.StableAccessTokenRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtil {
    private static Logger logger = LoggerFactory.getLogger(TokenUtil.class);

    /**
     * 获取访问令牌<br/>
     *
     * @param appId     公众号ID
     * @param appSecret 公众号密钥
     * @return 响应结果
     */
    public static AccessTokenRes getAccessToken(String appId, String appSecret) {
        AccessTokenReq req = AccessTokenReq.build(appId, appSecret);
        return getAccessToken(req);
    }

    /**
     * 获取访问令牌<br/>
     *
     * @param req 请求体
     * @return 响应结果
     */
    public static AccessTokenRes getAccessToken(AccessTokenReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("微信公众号 获取访问令牌: ");

        // 获取access_token的接口地址（GET） 限200（次/天）
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";

        url = url.replace("APPID", req.getAppId()).replace("APPSECRET", req.getAppSecret());

        AccessTokenRes res = new AccessTokenRes();
        return SendUtil.get(msgPre, url, req, res, null);
    }

    /**
     * 获取稳定版接口调用凭据<br/>
     *
     * @param appId     公众号ID
     * @param appSecret 公众号密钥
     * @return 响应结果
     */
    public static StableAccessTokenRes getStableAccessToken(String appId, String appSecret) {
        StableAccessTokenReq req = StableAccessTokenReq.build(appId, appSecret);
        return getStableAccessToken(req);
    }

    /**
     * 获取稳定版接口调用凭据<br/>
     *
     * @param req 请求体
     * @return 响应结果
     */
    public static StableAccessTokenRes getStableAccessToken(StableAccessTokenReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("微信公众号 获取稳定版接口调用凭据: ");

        String url = "https://api.weixin.qq.com/cgi-bin/stable_token";

        req.setBody(req.toBody());
        StableAccessTokenRes res = new StableAccessTokenRes();
        return SendUtil.post(msgPre, url, req, res, null);
    }


}
