package cn.net.wanmo.plugin.wechat.officialaccount.util.accesstoken.pojo;

import cn.net.wanmo.common.send.BaseReq;
import com.alibaba.fastjson2.JSONObject;

public class StableAccessTokenReq extends BaseReq {


    /**
     * 创建请求对象
     *
     * @param appId     公众号ID
     * @param appSecret 公众号密钥
     * @return 请求对象
     */
    public static StableAccessTokenReq build(String appId, String appSecret) {
        return build(appId, appSecret, false);
    }

    /**
     * 创建请求对象
     *
     * @param appId        公众号ID
     * @param appSecret    公众号密钥
     * @param forceRefresh 强制刷新模式
     * @return 请求对象
     */
    public static StableAccessTokenReq build(String appId, String appSecret, boolean forceRefresh) {
        StableAccessTokenReq req = new StableAccessTokenReq();
        req.setAppId(appId);
        req.setAppSecret(appSecret);
        req.setForceRefresh(forceRefresh);
        return req;
    }

    @Override
    public String toBody() {
        JSONObject req = new JSONObject();
        req.put("grant_type", this.grantType);
        req.put("appid", this.appId);
        req.put("secret", this.appSecret);
        req.put("force_refresh", this.forceRefresh);
        return req.toJSONString();
    }

    // ===========================================================================================
    /**
     * string	是	填写 client_credential
     */
    private String grantType = "client_credential";
    /**
     * string	是	账号唯一凭证，即 AppID，可在「微信公众平台 - 设置 - 开发设置」页中获得。（需要已经成为开发者，且账号没有异常状态）
     */
    private String appId;
    /**
     * string	是	账号唯一凭证密钥，即 AppSecret，获取方式同 appid
     */
    private String appSecret;
    /**
     * boolean	否	默认使用 false。1. force_refresh = false 时为普通调用模式，access_token 有效期内重复调用该接口不会更新 access_token；2. 当force_refresh = true 时为强制刷新模式，会导致上次获取的 access_token 失效，并返回新的 access_token
     */
    private boolean forceRefresh;

    public String getGrantType() {
        return grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public boolean isForceRefresh() {
        return forceRefresh;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }
}
