package cn.net.wanmo.plugin.wechat.officialaccount.util.jsapiticket;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.jsapiticket.pojo.JsapiTicketReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.jsapiticket.pojo.JsapiTicketRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketUtil {
    private static Logger logger = LoggerFactory.getLogger(TicketUtil.class);


    /**
     * 获取访问令牌<br/>
     *
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static JsapiTicketRes getJsapiTicket(String accessToken) {
        String msgPre = CommonUtil.getInterfaceTitle("微信公众号 获取jsapi_ticket: ");

        String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi";
        url = url.replace("ACCESS_TOKEN", accessToken);

        JsapiTicketReq req = JsapiTicketReq.build();
        JsapiTicketRes res = new JsapiTicketRes();
        return SendUtil.get(msgPre, url, req, res, null);
    }
}
