package cn.net.wanmo.plugin.wechat.officialaccount.util.media;

import cn.net.wanmo.common.send.BaseReq;
import cn.net.wanmo.common.send.BodyType;
import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.media.enums.MediaType;
import cn.net.wanmo.plugin.wechat.officialaccount.util.media.pojo.MediaGetReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.media.pojo.MediaGetRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.media.pojo.MediaUploadReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.media.pojo.MediaUploadRes;

import java.io.File;

/**
 * <pre>
 * 注意点：
 * 1、临时素材media_id是可复用的。
 * 2、媒体文件在微信后台保存时间为3天，即3天后media_id失效。
 * 3、上传临时素材的格式、大小限制与公众平台官网一致。
 * 图片（image）: 10M，支持PNG\JPEG\JPG\GIF格式
 * 语音（voice）：2M，播放长度不超过60s，支持AMR\MP3格式
 * 视频（video）：10MB，支持MP4格式
 * 缩略图（thumb）：64KB，支持JPG格式
 * 4、需使用https调用本接口。
 * </pre>
 */
public class MediaUtil {
    /**
     * 新增临时素材<br/>
     *
     * @param accessToken 访问令牌
     * @param type        素材类型
     * @param media       素材文件
     * @return 响应结果
     */
    public static MediaUploadRes uploadMedia(String accessToken, MediaType type, File media) {
        String msgPre = CommonUtil.getInterfaceTitle("微信公众号 新增临时素材: ");

        String url = "https://api.weixin.qq.com/cgi-bin/media/upload?access_token=ACCESS_TOKEN&type=TYPE";
        url = url.replace("ACCESS_TOKEN", accessToken);
        url = url.replace("TYPE", type.name());

        MediaUploadReq req = new MediaUploadReq();
        {
            BaseReq.ReqFile reqFile = req.newReqFile("file", media);
            req.setFile(reqFile);
        }
        MediaUploadRes res = new MediaUploadRes();
        return SendUtil.upload(msgPre, url, req, res, null);
    }

    /**
     * 获取临时素材<br/>
     *
     * @param accessToken 访问令牌
     * @param type        素材类型
     * @param mediaId     素材ID
     * @return 响应结果
     */
    public static MediaGetRes getMedia(String accessToken, MediaType type, String mediaId) {
        String msgPre = CommonUtil.getInterfaceTitle("微信公众号 获取临时素材: ");

        String url = "https://api.weixin.qq.com/cgi-bin/media/get?access_token=ACCESS_TOKEN&media_id=MEDIA_ID";
        url = url.replace("ACCESS_TOKEN", accessToken);
        url = url.replace("MEDIA_ID", mediaId);

        MediaGetReq req = new MediaGetReq();
        MediaGetRes res = new MediaGetRes();

        switch (type) {
            case video:
                res.setBodyType(BodyType.obj);
                res = SendUtil.get(msgPre, url, req, res, null);
                break;
            default:
                res.setBodyType(BodyType.file);
                res = SendUtil.getFile(msgPre, url, req, res, null);
        }
        return res;
    }
}
