package cn.net.wanmo.plugin.wechat.officialaccount.util.media.enums;

import cn.net.wanmo.common.util.StringUtil;

/**
 * 二维码类型
 */
public enum MediaType {
    undefined("未定义"),
    image("图片"),
    voice("语音"),
    video("视频"),
    thumb("缩略图：主要用于视频与音乐格式的缩略图"),
    ;

    private final String desc;

    MediaType(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public static MediaType convertOf(String name) {
        MediaType r = MediaType.undefined;
        if (StringUtil.isBlank(name)) {
            return r;
        }

        for (MediaType mediaType : MediaType.values()) {
            if (StringUtil.equals(mediaType.name(), name)) {
                r = mediaType;
                break;
            }
        }

        return r;
    }
}
