package cn.net.wanmo.plugin.wechat.officialaccount.util.media.pojo;

import cn.net.wanmo.common.http.jdk.HttpJdkUtil;
import cn.net.wanmo.common.http.jdk.pojo.ResData;
import cn.net.wanmo.common.result.HttpResult;
import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.common.send.BodyType;
import cn.net.wanmo.plugin.wechat.officialaccount.pojo.WechatBaseRes;
import com.alibaba.fastjson2.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.List;
import java.util.Map;

public class MediaGetRes extends WechatBaseRes<MediaGetData> {
    private Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    protected void initData() {
        this.data = new MediaGetData();
    }

    @Override
    public BaseRes parseCodeMsg(String resBody) {
        this.errCode = successDataCode();
        return this;
    }


    @Override
    public BaseRes parseFile(String resBody) {
        String contentType = getContentType();

        if (contentType.contains("text") || contentType.contains("json")) {
            super.parseCodeMsg(resBody);
        } else {
            File file = new File(resBody);
            this.data.setFile(file);
        }

        return super.parseFile(resBody);
    }

    @Override
    public BaseRes parseObj(String resBody) {
        try { // 获取视频文件处理
            JSONObject object = JSONObject.parseObject(resBody);
            String videoUrl = object.getString("video_url");

            HttpResult<ResData> fileRes = HttpJdkUtil.get(videoUrl).send(true);
            if (fileRes.isSuccess()) {
                this.data.setFile(fileRes.getData().getFile());
            } else {
                logger.error("微信公众号 获取临时素材 视频类型 获取失败：{}", videoUrl);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        return super.parseObj(resBody);
    }
}
