package cn.net.wanmo.plugin.wechat.officialaccount.util.media.pojo;

import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.plugin.wechat.officialaccount.pojo.WechatBaseRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.media.enums.MediaType;
import com.alibaba.fastjson2.JSONObject;

public class MediaUploadRes extends WechatBaseRes<MediaUploadData> {
    @Override
    protected void initData() {
        this.data = new MediaUploadData();
    }

    @Override
    public BaseRes parseObj(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);

        this.data.setType(MediaType.convertOf(object.getString("type")));
        this.data.setMediaId(object.getString("media_id"));
        this.data.setCreatedAt(object.getLong("created_at"));

        return super.parseObj(resBody);
    }
}
