package cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req;

import cn.net.wanmo.common.util.StringUtil;

/**
 * 公众号请求事件类型
 */
public enum ReqEventType {
    unknown("unknown", "未知类型"),
    subscribe("subscribe", "关注事件"),
    unsubscribe("unsubscribe", "取消关注事件"),
    SCAN("SCAN", "扫描带参数二维码事件"),
    LOCATION("LOCATION", "上报地理位置事件"),
    ;

    private final String value;
    private final String label;

    ReqEventType(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }

    public static ReqEventType convertOf(String value) {
        ReqEventType r = ReqEventType.unknown;

        for (ReqEventType type : values()) {
            if (StringUtil.equals(value, type.getValue())) {
                r = type;
                break;
            }
        }

        return r;
    }
}
