package cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.base.EventReqMessage;

import java.util.Map;

/**
 * 点击菜单拉取消息时的事件推送<br/>
 * 用户点击自定义菜单后，微信会把点击事件推送给开发者，请注意，点击菜单弹出子菜单，不会产生上报。<br/>
 * 点击菜单跳转链接时的事件推送
 * 事件类型，CLICK
 */
public class MenuClickMessage extends EventReqMessage {

    /**
     * 点击菜单跳转链接时的事件推送: 事件KEY值，与自定义菜单接口中KEY值对应 <br/>
     */
    private String eventKey;

    public MenuClickMessage() {
    }

    public MenuClickMessage(Map<String, String> requestMap) {
        super(requestMap);
        this.eventKey = requestMap.get("EventKey");
    }

    public String getEventKey() {
        return eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }
}
